/************************************************************************
**
**  Copyright (C) 2010  Strahinja Markovic
**
**  This file is part of FlightCrew.
**
**  FlightCrew is free software: you can redistribute it and/or modify
**  it under the terms of the GNU Lesser General Public License as published
**  by the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  FlightCrew is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU Lesser General Public License for more details.
**
**  You should have received a copy of the GNU Lesser General Public License
**  along with FlightCrew.  If not, see <http://www.gnu.org/licenses/>.
**
*************************************************************************/

#include <stdafx.h>

/*
   XML Encryption Syntax and Processing, XSD
   
   Specification: http://www.w3.org/TR/xmlenc-core/

   Namespace: http://www.w3.org/2001/04/xmlenc#
   
   Taken from: http://www.w3.org/TR/xmlenc-core/xenc-schema.xsd
   
 */

namespace FlightCrew
{

const char*         XENC_SCHEMA_XSD_ID  = "xenc-schema.xsd";
const unsigned int  XENC_SCHEMA_XSD_LEN = 4829;
const unsigned char XENC_SCHEMA_XSD[]   = {
  0x3c, 0x3f, 0x78, 0x6d, 0x6c, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x31, 0x2e, 0x30, 0x22, 0x20, 0x65, 0x6e, 0x63, 0x6f,
  0x64, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x75, 0x74, 0x66, 0x2d, 0x38, 0x22,
  0x3f, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x20, 0x78,
  0x6d, 0x6c, 0x6e, 0x73, 0x3d, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
  0x32, 0x30, 0x30, 0x31, 0x2f, 0x58, 0x4d, 0x4c, 0x53, 0x63, 0x68, 0x65,
  0x6d, 0x61, 0x27, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d,
  0x27, 0x31, 0x2e, 0x30, 0x27, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x3a, 0x78, 0x65, 0x6e, 0x63,
  0x3d, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
  0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x32, 0x30, 0x30, 0x31,
  0x2f, 0x30, 0x34, 0x2f, 0x78, 0x6d, 0x6c, 0x65, 0x6e, 0x63, 0x23, 0x27,
  0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x78, 0x6d, 0x6c,
  0x6e, 0x73, 0x3a, 0x64, 0x73, 0x3d, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67,
  0x2f, 0x32, 0x30, 0x30, 0x30, 0x2f, 0x30, 0x39, 0x2f, 0x78, 0x6d, 0x6c,
  0x64, 0x73, 0x69, 0x67, 0x23, 0x27, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4e, 0x61, 0x6d,
  0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x27, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72,
  0x67, 0x2f, 0x32, 0x30, 0x30, 0x31, 0x2f, 0x30, 0x34, 0x2f, 0x78, 0x6d,
  0x6c, 0x65, 0x6e, 0x63, 0x23, 0x27, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x46, 0x6f,
  0x72, 0x6d, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x3d, 0x27, 0x71,
  0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x27, 0x3e, 0x0a, 0x0a,
  0x20, 0x20, 0x3c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x27, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f,
  0x72, 0x67, 0x2f, 0x32, 0x30, 0x30, 0x30, 0x2f, 0x30, 0x39, 0x2f, 0x78,
  0x6d, 0x6c, 0x64, 0x73, 0x69, 0x67, 0x23, 0x27, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x73, 0x63, 0x68, 0x65, 0x6d,
  0x61, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x27, 0x78,
  0x6d, 0x6c, 0x64, 0x73, 0x69, 0x67, 0x2d, 0x63, 0x6f, 0x72, 0x65, 0x2d,
  0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x78, 0x73, 0x64, 0x27, 0x2f,
  0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27,
  0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70,
  0x65, 0x27, 0x20, 0x61, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x3d,
  0x27, 0x74, 0x72, 0x75, 0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x3c, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72,
  0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
  0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63,
  0x3a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
  0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x27, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63,
  0x75, 0x72, 0x73, 0x3d, 0x27, 0x30, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x64, 0x73, 0x3a, 0x4b, 0x65, 0x79,
  0x49, 0x6e, 0x66, 0x6f, 0x27, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63,
  0x75, 0x72, 0x73, 0x3d, 0x27, 0x30, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x43,
  0x69, 0x70, 0x68, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x27, 0x2f, 0x3e,
  0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x20, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x78, 0x65, 0x6e,
  0x63, 0x3a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x27, 0x20,
  0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x27, 0x30,
  0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x73, 0x65,
  0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x3c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x27, 0x49, 0x64, 0x27, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x27, 0x49, 0x44, 0x27, 0x20, 0x75, 0x73, 0x65, 0x3d, 0x27,
  0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x27, 0x2f, 0x3e, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x54, 0x79, 0x70,
  0x65, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x61, 0x6e, 0x79,
  0x55, 0x52, 0x49, 0x27, 0x20, 0x75, 0x73, 0x65, 0x3d, 0x27, 0x6f, 0x70,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x4d, 0x69, 0x6d, 0x65, 0x54,
  0x79, 0x70, 0x65, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x73,
  0x74, 0x72, 0x69, 0x6e, 0x67, 0x27, 0x20, 0x75, 0x73, 0x65, 0x3d, 0x27,
  0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x27, 0x2f, 0x3e, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63,
  0x6f, 0x64, 0x69, 0x6e, 0x67, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x27, 0x61, 0x6e, 0x79, 0x55, 0x52, 0x49, 0x27, 0x20, 0x75, 0x73, 0x65,
  0x3d, 0x27, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x27, 0x2f,
  0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x0a, 0x20, 0x20,
  0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72, 0x79,
  0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54,
  0x79, 0x70, 0x65, 0x27, 0x20, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x3d, 0x27,
  0x74, 0x72, 0x75, 0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x4b, 0x65, 0x79, 0x53, 0x69,
  0x7a, 0x65, 0x27, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72,
  0x73, 0x3d, 0x27, 0x30, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27,
  0x78, 0x65, 0x6e, 0x63, 0x3a, 0x4b, 0x65, 0x79, 0x53, 0x69, 0x7a, 0x65,
  0x54, 0x79, 0x70, 0x65, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x27, 0x4f, 0x41, 0x45, 0x50, 0x70, 0x61, 0x72,
  0x61, 0x6d, 0x73, 0x27, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75,
  0x72, 0x73, 0x3d, 0x27, 0x30, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x27, 0x62, 0x61, 0x73, 0x65, 0x36, 0x34, 0x42, 0x69, 0x6e, 0x61, 0x72,
  0x79, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x61, 0x6e, 0x79, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
  0x65, 0x3d, 0x27, 0x23, 0x23, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x27, 0x20,
  0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x27, 0x30,
  0x27, 0x20, 0x6d, 0x61, 0x78, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d,
  0x27, 0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x27, 0x2f,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x73, 0x65, 0x71, 0x75,
  0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x61,
  0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x27, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
  0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x61, 0x6e, 0x79, 0x55,
  0x52, 0x49, 0x27, 0x20, 0x75, 0x73, 0x65, 0x3d, 0x27, 0x72, 0x65, 0x71,
  0x75, 0x69, 0x72, 0x65, 0x64, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x3c,
  0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65,
  0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x73, 0x69, 0x6d, 0x70,
  0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x27, 0x4b, 0x65, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x54, 0x79, 0x70, 0x65,
  0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x72, 0x65,
  0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x62, 0x61,
  0x73, 0x65, 0x3d, 0x22, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x22,
  0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x73, 0x69, 0x6d,
  0x70, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x20, 0x20,
  0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x27, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x44, 0x61, 0x74,
  0x61, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e,
  0x63, 0x3a, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61,
  0x54, 0x79, 0x70, 0x65, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x27, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x44,
  0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x3c, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x3e, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x43, 0x69,
  0x70, 0x68, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x27, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x27, 0x62, 0x61, 0x73, 0x65, 0x36, 0x34, 0x42,
  0x69, 0x6e, 0x61, 0x72, 0x79, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x43,
  0x69, 0x70, 0x68, 0x65, 0x72, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x63, 0x65, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x2f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79,
  0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x43,
  0x69, 0x70, 0x68, 0x65, 0x72, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x63, 0x65, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x78, 0x65,
  0x6e, 0x63, 0x3a, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x52, 0x65, 0x66,
  0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x27, 0x2f,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27,
  0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
  0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x27, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73,
  0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63,
  0x3a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x54,
  0x79, 0x70, 0x65, 0x27, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75,
  0x72, 0x73, 0x3d, 0x27, 0x30, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x61, 0x74,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x27, 0x55, 0x52, 0x49, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x27, 0x61, 0x6e, 0x79, 0x55, 0x52, 0x49, 0x27, 0x20, 0x75, 0x73, 0x65,
  0x3d, 0x27, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x27, 0x2f,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
  0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79,
  0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x54, 0x72, 0x61,
  0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x54, 0x79, 0x70, 0x65, 0x27,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x73, 0x65,
  0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x64, 0x73, 0x3a, 0x54, 0x72,
  0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x27, 0x20, 0x6d, 0x61, 0x78,
  0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x27, 0x75, 0x6e, 0x62, 0x6f,
  0x75, 0x6e, 0x64, 0x65, 0x64, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
  0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a,
  0x0a, 0x0a, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72, 0x79,
  0x70, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x27, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x45, 0x6e, 0x63,
  0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79,
  0x70, 0x65, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64,
  0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x27, 0x3e, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x43,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x62, 0x61, 0x73, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a,
  0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70,
  0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x3e, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x78, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3e, 0x0a, 0x20, 0x20,
  0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70,
  0x65, 0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x43,
  0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x64,
  0x73, 0x3a, 0x4b, 0x65, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x20, 0x2d, 0x2d,
  0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72,
  0x79, 0x70, 0x74, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x27, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x45, 0x6e, 0x63,
  0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70,
  0x65, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x4b,
  0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x43, 0x6f, 0x6e,
  0x74, 0x65, 0x6e, 0x74, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x3c, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x62,
  0x61, 0x73, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x45, 0x6e,
  0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x27,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x73,
  0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x20, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x78, 0x65, 0x6e,
  0x63, 0x3a, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4c,
  0x69, 0x73, 0x74, 0x27, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75,
  0x72, 0x73, 0x3d, 0x27, 0x30, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x43, 0x61,
  0x72, 0x72, 0x69, 0x65, 0x64, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65,
  0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x73, 0x74, 0x72, 0x69,
  0x6e, 0x67, 0x27, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72,
  0x73, 0x3d, 0x27, 0x30, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
  0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x3c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x27, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65,
  0x6e, 0x74, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x73, 0x74,
  0x72, 0x69, 0x6e, 0x67, 0x27, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x75, 0x73, 0x65, 0x3d, 0x27, 0x6f, 0x70, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
  0x6e, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x78, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3e,
  0x0a, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78,
  0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x22, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d,
  0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70,
  0x65, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x63, 0x6f,
  0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x22, 0x41, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x22,
  0x20, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x3d, 0x22, 0x74, 0x72, 0x75, 0x65,
  0x22, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x73, 0x65,
  0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x4b, 0x41, 0x2d, 0x4e, 0x6f,
  0x6e, 0x63, 0x65, 0x22, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75,
  0x72, 0x73, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x62, 0x61, 0x73, 0x65, 0x36, 0x34, 0x42, 0x69, 0x6e, 0x61, 0x72,
  0x79, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x64, 0x73, 0x3a, 0x44,
  0x69, 0x67, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22,
  0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x22,
  0x30, 0x22, 0x2f, 0x3e, 0x20, 0x2d, 0x2d, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x61, 0x6e, 0x79, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x3d, 0x22, 0x23, 0x23, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x22, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63,
  0x75, 0x72, 0x73, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x6d, 0x61, 0x78, 0x4f,
  0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x22, 0x75, 0x6e, 0x62, 0x6f, 0x75,
  0x6e, 0x64, 0x65, 0x64, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x4f, 0x72, 0x69, 0x67, 0x69,
  0x6e, 0x61, 0x74, 0x6f, 0x72, 0x4b, 0x65, 0x79, 0x49, 0x6e, 0x66, 0x6f,
  0x22, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d,
  0x22, 0x30, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x64, 0x73,
  0x3a, 0x4b, 0x65, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65,
  0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74,
  0x4b, 0x65, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x20, 0x6d, 0x69, 0x6e,
  0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x64, 0x73, 0x3a, 0x4b, 0x65, 0x79, 0x49,
  0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x22, 0x2f, 0x3e, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x22, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
  0x6d, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x61, 0x6e, 0x79,
  0x55, 0x52, 0x49, 0x22, 0x20, 0x75, 0x73, 0x65, 0x3d, 0x22, 0x72, 0x65,
  0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54,
  0x79, 0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x3c, 0x21, 0x2d, 0x2d,
  0x20, 0x45, 0x6e, 0x64, 0x20, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x73, 0x3a, 0x4b, 0x65, 0x79, 0x49,
  0x6e, 0x66, 0x6f, 0x20, 0x2d, 0x2d, 0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x3c,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x27, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4c,
  0x69, 0x73, 0x74, 0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x63, 0x68, 0x6f, 0x69, 0x63,
  0x65, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d,
  0x27, 0x31, 0x27, 0x20, 0x6d, 0x61, 0x78, 0x4f, 0x63, 0x63, 0x75, 0x72,
  0x73, 0x3d, 0x27, 0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64,
  0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x27, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
  0x6e, 0x63, 0x65, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x78,
  0x65, 0x6e, 0x63, 0x3a, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
  0x65, 0x54, 0x79, 0x70, 0x65, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x4b, 0x65, 0x79, 0x52,
  0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x27, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x52, 0x65, 0x66,
  0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x27, 0x2f,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x68,
  0x6f, 0x69, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f,
  0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e,
  0x0a, 0x20, 0x20, 0x3c, 0x2f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27,
  0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70,
  0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x73, 0x65, 0x71,
  0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x3c, 0x61, 0x6e, 0x79, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
  0x61, 0x63, 0x65, 0x3d, 0x27, 0x23, 0x23, 0x6f, 0x74, 0x68, 0x65, 0x72,
  0x27, 0x20, 0x6d, 0x69, 0x6e, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73, 0x3d,
  0x27, 0x30, 0x27, 0x20, 0x6d, 0x61, 0x78, 0x4f, 0x63, 0x63, 0x75, 0x72,
  0x73, 0x3d, 0x27, 0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64,
  0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x73, 0x65,
  0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x3c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x27, 0x55, 0x52, 0x49, 0x27, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x27, 0x61, 0x6e, 0x79, 0x55, 0x52, 0x49, 0x27, 0x20,
  0x75, 0x73, 0x65, 0x3d, 0x27, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
  0x64, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x0a,
  0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
  0x73, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e,
  0x63, 0x3a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x54, 0x79,
  0x70, 0x65, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x78, 0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
  0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x54,
  0x79, 0x70, 0x65, 0x27, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x73,
  0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20,
  0x72, 0x65, 0x66, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x45, 0x6e,
  0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70,
  0x65, 0x72, 0x74, 0x79, 0x27, 0x20, 0x6d, 0x61, 0x78, 0x4f, 0x63, 0x63,
  0x75, 0x72, 0x73, 0x3d, 0x27, 0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
  0x65, 0x64, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f,
  0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x49, 0x64, 0x27, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x27, 0x49, 0x44, 0x27, 0x20, 0x75, 0x73, 0x65,
  0x3d, 0x27, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x27, 0x2f,
  0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x78, 0x54, 0x79, 0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x20, 0x20, 0x20, 0x20,
  0x3c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x27, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
  0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x27, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x27, 0x78, 0x65, 0x6e, 0x63, 0x3a, 0x45, 0x6e,
  0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70,
  0x65, 0x72, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x27, 0x2f, 0x3e, 0x0a,
  0x20, 0x20, 0x20, 0x20, 0x3c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78,
  0x54, 0x79, 0x70, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x27, 0x45,
  0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
  0x70, 0x65, 0x72, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x27, 0x20, 0x6d,
  0x69, 0x78, 0x65, 0x64, 0x3d, 0x27, 0x74, 0x72, 0x75, 0x65, 0x27, 0x3e,
  0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x63, 0x68, 0x6f, 0x69,
  0x63, 0x65, 0x20, 0x6d, 0x61, 0x78, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x73,
  0x3d, 0x27, 0x75, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x27,
  0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x61,
  0x6e, 0x79, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
  0x3d, 0x27, 0x23, 0x23, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x27, 0x20, 0x70,
  0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x73, 0x3d, 0x27, 0x6c, 0x61, 0x78, 0x27, 0x2f, 0x3e, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x2f, 0x63, 0x68, 0x6f, 0x69, 0x63,
  0x65, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x61, 0x74,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x3d, 0x27, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x27, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x27, 0x61, 0x6e, 0x79, 0x55, 0x52, 0x49, 0x27, 0x20,
  0x75, 0x73, 0x65, 0x3d, 0x27, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61,
  0x6c, 0x27, 0x2f, 0x3e, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
  0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x27, 0x49, 0x64, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65,
  0x3d, 0x27, 0x49, 0x44, 0x27, 0x20, 0x75, 0x73, 0x65, 0x3d, 0x27, 0x6f,
  0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x27, 0x2f, 0x3e, 0x0a, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x3c, 0x61, 0x6e, 0x79, 0x41, 0x74, 0x74,
  0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x73,
  0x70, 0x61, 0x63, 0x65, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
  0x58, 0x4d, 0x4c, 0x2f, 0x31, 0x39, 0x39, 0x38, 0x2f, 0x6e, 0x61, 0x6d,
  0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x2f, 0x3e, 0x0a, 0x20, 0x20,
  0x20, 0x20, 0x3c, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x54,
  0x79, 0x70, 0x65, 0x3e, 0x0a, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x68, 0x65,
  0x6d, 0x61, 0x3e, 0x0a, 0x0a
};


} //namespace FlightCrew