/**
 * @author Jorge Bay Gondra
 */
import * as rcModule from './remote-connection.js';
declare const RemoteConnection: typeof rcModule.RemoteConnection;
import Bytecode from '../process/bytecode.js';
import { ConnectionOptions } from './connection.js';
/**
 * Represents the default {@link RemoteConnection} implementation.
 */
export default class DriverRemoteConnection extends RemoteConnection {
    private readonly _client;
    /**
     * Creates a new instance of {@link DriverRemoteConnection}.
     * @param {String} url The resource uri.
     * @param {ConnectionOptions} [options] The connection options.
     * @param {Array} [options.ca] Trusted certificates.
     * @param {String|Array|Buffer} [options.cert] The certificate key.
     * @param {String} [options.mimeType] The mime type to use.
     * @param {String|Buffer} [options.pfx] The private key, certificate, and CA certs.
     * @param {GraphSONReader} [options.reader] The reader to use.
     * @param {Boolean} [options.rejectUnauthorized] Determines whether to verify or not the server certificate.
     * @param {String} [options.traversalSource] The traversal source. Defaults to: 'g'.
     * @param {GraphSONWriter} [options.writer] The writer to use.
     * @param {Authenticator} [options.authenticator] The authentication handler to use.
     * @param {Object} [options.headers] An associative array containing the additional header key/values for the initial request.
     * @param {Boolean} [options.enableUserAgentOnConnect] Determines if a user agent will be sent during connection handshake. Defaults to: true
     * @param {http.Agent} [options.agent] The http.Agent implementation to use.
     * @constructor
     */
    constructor(url: string, options?: ConnectionOptions);
    /** @override */
    open(): Promise<void>;
    /** @override */
    get isOpen(): boolean;
    /** @override */
    submit(bytecode: Bytecode): Promise<rcModule.RemoteTraversal>;
    createSession(): DriverRemoteConnection;
    get isSessionBound(): boolean;
    commit(): Promise<any>;
    rollback(): Promise<any>;
    close(): Promise<void>;
    /** @override */
    addListener(event: string, handler: (...args: any[]) => unknown): void;
    /** @override */
    removeListener(event: string, handler: (...args: any[]) => unknown): void;
}
export {};
