/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.nio.ByteBuffer;

/**
 * Represents a factory to create {@link Buffer} instances from {@link T} instances.
 */
public interface BufferFactory<T> {

    /**
     * Creates a new {@link Buffer} given a {@link T} instance.
     * @param value
     * @return
     */
    Buffer create(final T value);

    /**
     * Wraps a NIO buffer.
     */
    Buffer wrap(final ByteBuffer value);
}
