/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.plastic;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.apache.tapestry5.internal.plastic.Lockable;
import org.apache.tapestry5.internal.plastic.NoopDelegate;
import org.apache.tapestry5.internal.plastic.PlasticClassPool;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.PlasticClassListener;
import org.apache.tapestry5.plastic.PlasticClassListenerHub;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticManagerDelegate;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.TransformationOption;

public class PlasticManager
implements PlasticClassListenerHub {
    private final PlasticClassPool pool;

    public static PlasticManagerBuilder withContextClassLoader() {
        return PlasticManager.withClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static PlasticManagerBuilder withClassLoader(ClassLoader loader) {
        return new PlasticManagerBuilder(loader);
    }

    private PlasticManager(ClassLoader parentClassLoader, PlasticManagerDelegate delegate, Set<String> controlledPackageNames, Set<TransformationOption> options) {
        assert (parentClassLoader != null);
        assert (delegate != null);
        assert (controlledPackageNames != null);
        this.pool = new PlasticClassPool(parentClassLoader, delegate, controlledPackageNames, options);
    }

    public ClassLoader getClassLoader() {
        return this.pool.getClassLoader();
    }

    <T> PlasticClassTransformation<T> getPlasticClass(String className) throws ClassNotFoundException {
        assert (PlasticInternalUtils.isNonBlank(className));
        return this.pool.getPlasticClassTransformation(className);
    }

    public <T> ClassInstantiator<T> getClassInstantiator(String className) {
        return this.pool.getClassInstantiator(className);
    }

    public <T> ClassInstantiator<T> createClass(Class<T> baseClass, PlasticClassTransformer callback) {
        assert (baseClass != null);
        assert (callback != null);
        if (baseClass.isInterface()) {
            throw new IllegalArgumentException(String.format("Class %s defines an interface, not a base class.", baseClass.getName()));
        }
        String name = String.format("$%s_%s", baseClass.getSimpleName(), PlasticUtils.nextUID());
        PlasticClassTransformation transformation = this.pool.createTransformation(baseClass.getName(), name);
        callback.transform(transformation.getPlasticClass());
        return transformation.createInstantiator();
    }

    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, PlasticClassTransformer callback) {
        return this.createProxy(interfaceType, null, callback);
    }

    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, PlasticClassTransformer callback, boolean introduceInterface) {
        return this.createProxy(interfaceType, null, callback, introduceInterface);
    }

    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, Class<? extends T> implementationType, PlasticClassTransformer callback) {
        return this.createProxy(interfaceType, implementationType, callback, true);
    }

    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, Class<? extends T> implementationType, PlasticClassTransformer callback, boolean introduceInterface) {
        assert (callback != null);
        PlasticClassTransformation<T> transformation = this.createProxyTransformation(interfaceType, implementationType, introduceInterface);
        callback.transform(transformation.getPlasticClass());
        return transformation.createInstantiator();
    }

    public <T> PlasticClassTransformation<T> createProxyTransformation(Class interfaceType, Class implementationType) {
        return this.createProxyTransformation(interfaceType, implementationType, true);
    }

    public <T> PlasticClassTransformation<T> createProxyTransformation(Class interfaceType, Class implementationType, boolean introduceInterface) {
        assert (interfaceType != null);
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException(String.format("Class %s is not an interface; proxies may only be created for interfaces.", interfaceType.getName()));
        }
        String name = String.format("$%s_%s", interfaceType.getSimpleName(), PlasticUtils.nextUID());
        String implementationClassName = implementationType != null ? implementationType.getName() : null;
        PlasticClassTransformation result = this.pool.createTransformation("java.lang.Object", name, implementationClassName);
        if (introduceInterface) {
            result.getPlasticClass().introduceInterface(interfaceType);
        }
        return result;
    }

    @Override
    public void addPlasticClassListener(PlasticClassListener listener) {
        this.pool.addPlasticClassListener(listener);
    }

    @Override
    public void removePlasticClassListener(PlasticClassListener listener) {
        this.pool.removePlasticClassListener(listener);
    }

    public boolean shouldInterceptClassLoading(String className) {
        return this.pool.shouldInterceptClassLoading(className);
    }

    public PlasticClassPool getPool() {
        return this.pool;
    }

    public static class PlasticManagerBuilder
    extends Lockable {
        private final ClassLoader loader;
        private PlasticManagerDelegate delegate = new NoopDelegate();
        private final Set<String> packages = PlasticInternalUtils.newSet();
        private final Set<TransformationOption> options = EnumSet.noneOf(TransformationOption.class);

        private PlasticManagerBuilder(ClassLoader loader) {
            assert (loader != null);
            this.loader = loader;
        }

        public PlasticManagerBuilder delegate(PlasticManagerDelegate delegate) {
            assert (delegate != null);
            this.check();
            this.delegate = delegate;
            return this;
        }

        public PlasticManagerBuilder packages(Collection<String> packageNames) {
            this.check();
            this.packages.addAll(packageNames);
            return this;
        }

        public PlasticManagerBuilder enable(TransformationOption option) {
            this.check();
            this.options.add(option);
            return this;
        }

        public PlasticManager create() {
            this.lock();
            return new PlasticManager(this.loader, this.delegate, this.packages, this.options);
        }
    }
}

