/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tapestry5.http.Link;

public final class HttpStatus {
    private static final String CONTENT_LOCATION_HTTP_HEADER = "Content-Location";
    private static final String LOCATION_HTTP_HEADER = "Location";
    private final int statusCode;
    private String responseBody;
    private String contentType;
    private Map<String, String> extraHttpHeaders;

    public static HttpStatus ok() {
        return new HttpStatus(200);
    }

    public static HttpStatus created() {
        return new HttpStatus(201);
    }

    public static HttpStatus accepted() {
        return new HttpStatus(202);
    }

    public static HttpStatus notFound() {
        return new HttpStatus(404);
    }

    public static HttpStatus forbidden() {
        return new HttpStatus(403);
    }

    public static HttpStatus badRequest() {
        return new HttpStatus(400);
    }

    public static HttpStatus unauthorized() {
        return new HttpStatus(401);
    }

    public static HttpStatus seeOther(String location) {
        return new HttpStatus(303).withLocation(location);
    }

    public static HttpStatus seeOther(Link location) {
        return new HttpStatus(303).withLocation(location);
    }

    public static HttpStatus movedPermanently(String location) {
        return new HttpStatus(301).withLocation(location);
    }

    public static HttpStatus movedPermanently(Link link) {
        return HttpStatus.movedPermanently(link.toRedirectURI());
    }

    public static HttpStatus temporaryRedirect(String location) {
        return new HttpStatus(302).withLocation(location);
    }

    public static HttpStatus temporaryRedirect(Link location) {
        return HttpStatus.temporaryRedirect(location.toRedirectURI());
    }

    public HttpStatus(int statusCode) {
        this(statusCode, null, null);
    }

    public HttpStatus(int statusCode, String responseBody) {
        this(statusCode, responseBody, "text/plain");
    }

    public HttpStatus(int statusCode, String responseBody, String contentType) {
        this.statusCode = statusCode;
        this.responseBody = responseBody;
        this.contentType = contentType;
    }

    public HttpStatus withLocation(Link location) {
        return this.withLocation(location.toRedirectURI());
    }

    public HttpStatus withLocation(String location) {
        return this.withHttpHeader(LOCATION_HTTP_HEADER, location);
    }

    public HttpStatus withContentLocation(String location) {
        return this.withHttpHeader(CONTENT_LOCATION_HTTP_HEADER, location);
    }

    public HttpStatus withContentLocation(Link link) {
        return this.withHttpHeader(CONTENT_LOCATION_HTTP_HEADER, link.toRedirectURI());
    }

    public HttpStatus withHttpHeader(String name, String value) {
        Objects.requireNonNull(name, "Parameter name cannot be null");
        Objects.requireNonNull(value, "Parameter value cannot be null");
        if (this.extraHttpHeaders == null) {
            this.extraHttpHeaders = new HashMap<String, String>(3);
        }
        this.extraHttpHeaders.put(name, value);
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getExtraHttpHeaders() {
        return this.extraHttpHeaders != null ? this.extraHttpHeaders : Collections.EMPTY_MAP;
    }
}

