/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Cached;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.transform.MethodResultCache;
import org.apache.tapestry5.internal.transform.PropertyValueProviderWorker;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.PropertyAccessType;
import org.apache.tapestry5.plastic.PropertyValueProvider;
import org.apache.tapestry5.runtime.PageLifecycleListener;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class CachedWorker
implements ComponentClassTransformWorker2 {
    private static final String WATCH_BINDING_PREFIX = "cache$watchBinding$";
    private static final String FIELD_PREFIX = "cache$";
    private static final String META_PROPERTY = "cachedWorker";
    private static final String MODIFIERS = "modifiers";
    private static final String RETURN_TYPE = "returnType";
    private static final String NAME = "name";
    private static final String GENERIC_SIGNATURE = "genericSignature";
    private static final String ARGUMENT_TYPES = "argumentTypes";
    private static final String CHECKED_EXCEPTION_TYPES = "checkedExceptionTypes";
    private static final String WATCH = "watch";
    private final BindingSource bindingSource;
    private final PerthreadManager perThreadManager;
    private final PropertyValueProviderWorker propertyValueProviderWorker;
    private final boolean multipleClassLoaders;
    private final MethodResultCacheFactory nonWatchFactory = new MethodResultCacheFactory(){

        @Override
        public MethodResultCache create(Object instance) {
            return new SimpleMethodResultCache();
        }
    };

    public CachedWorker(BindingSource bindingSource, PerthreadManager perthreadManager, PropertyValueProviderWorker propertyValueProviderWorker, @Inject @Symbol(value="tapestry.production-mode") boolean productionMode, @Inject @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassloaders) {
        this.bindingSource = bindingSource;
        this.perThreadManager = perthreadManager;
        this.propertyValueProviderWorker = propertyValueProviderWorker;
        this.multipleClassLoaders = !productionMode && multipleClassloaders;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        HashMap<String, String> extraMethodCachedWatchMap;
        List methods = plasticClass.getMethodsWithAnnotation(Cached.class);
        HashSet<PlasticUtils.FieldInfo> fieldInfos = this.multipleClassLoaders ? new HashSet<PlasticUtils.FieldInfo>() : null;
        HashMap<String, String> hashMap = extraMethodCachedWatchMap = this.multipleClassLoaders ? new HashMap<String, String>() : null;
        if (this.multipleClassLoaders) {
            model.setMeta(META_PROPERTY, CachedWorker.toJSONArray(methods).toCompactString());
            HashSet<PlasticMethod> extraMethods = new HashSet<PlasticMethod>();
            for (ComponentModel parentModel = model.getParentModel(); parentModel != null; parentModel = parentModel.getParentModel()) {
                extraMethods.addAll(this.toPlasticMethodList(parentModel.getMeta(META_PROPERTY), plasticClass, extraMethodCachedWatchMap));
            }
            methods.addAll(extraMethods);
        }
        for (PlasticMethod method : methods) {
            this.validateMethod(method);
            this.adviseMethod(plasticClass, method, fieldInfos, model, extraMethodCachedWatchMap);
        }
        if (this.multipleClassLoaders && !fieldInfos.isEmpty()) {
            this.propertyValueProviderWorker.add(plasticClass, fieldInfos);
        }
    }

    private Collection<PlasticMethod> toPlasticMethodList(String meta, PlasticClass plasticClass, Map<String, String> extraMethodCachedWatchMap) {
        JSONArray array = new JSONArray(meta);
        ArrayList<PlasticMethod> methods = new ArrayList<PlasticMethod>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            methods.add(CachedWorker.toPlasticMethod(jsonObject, plasticClass, extraMethodCachedWatchMap));
        }
        return methods;
    }

    private static PlasticMethod toPlasticMethod(JSONObject jsonObject, PlasticClass plasticClass, Map<String, String> extraMethodCachedWatchMap) {
        int modifiers = jsonObject.getInt(MODIFIERS);
        String returnType = jsonObject.getString(RETURN_TYPE);
        String methodName = jsonObject.getString(NAME);
        String genericSignature = jsonObject.getStringOrDefault(GENERIC_SIGNATURE, null);
        JSONArray argumentTypesArray = jsonObject.getJSONArray(ARGUMENT_TYPES);
        String[] argumentTypes = argumentTypesArray.stream().collect(Collectors.toList()).toArray(new String[argumentTypesArray.size()]);
        JSONArray checkedExceptionTypesArray = jsonObject.getJSONArray(CHECKED_EXCEPTION_TYPES);
        String[] checkedExceptionTypes = checkedExceptionTypesArray.stream().collect(Collectors.toList()).toArray(new String[checkedExceptionTypesArray.size()]);
        if (!extraMethodCachedWatchMap.containsKey(methodName)) {
            extraMethodCachedWatchMap.put(methodName, jsonObject.getString(WATCH));
        }
        return plasticClass.introduceMethod(new MethodDescription(modifiers, returnType, methodName, argumentTypes, genericSignature, checkedExceptionTypes));
    }

    private static JSONArray toJSONArray(List<PlasticMethod> methods) {
        JSONArray array = new JSONArray();
        for (PlasticMethod method : methods) {
            array.add((Object)CachedWorker.toJSONObject(method));
        }
        return array;
    }

    private static JSONObject toJSONObject(PlasticMethod method) {
        MethodDescription description = method.getDescription();
        return new JSONObject(new Object[]{MODIFIERS, description.modifiers, RETURN_TYPE, description.returnType, NAME, description.methodName, GENERIC_SIGNATURE, description.genericSignature, ARGUMENT_TYPES, new JSONArray((Object[])description.argumentTypes), CHECKED_EXCEPTION_TYPES, new JSONArray((Object[])description.checkedExceptionTypes), WATCH, ((Cached)method.getAnnotation(Cached.class)).watch()});
    }

    private void adviseMethod(PlasticClass plasticClass, PlasticMethod method, Set<PlasticUtils.FieldInfo> fieldInfos, MutableComponentModel model, Map<String, String> extraMethodCachedWatchMap) {
        Cached annotation;
        PlasticField cacheField = plasticClass.introduceField(PerThreadValue.class, this.getFieldName(method));
        cacheField.injectComputed((ComputedValue)new ComputedValue<PerThreadValue>(){

            public PerThreadValue get(InstanceContext context) {
                return CachedWorker.this.perThreadManager.createValue();
            }
        });
        if (this.multipleClassLoaders) {
            fieldInfos.add(PlasticUtils.toFieldInfo((PlasticField)cacheField));
            cacheField.createAccessors(PropertyAccessType.READ_ONLY);
        }
        String expression = (annotation = (Cached)method.getAnnotation(Cached.class)) != null ? annotation.watch() : extraMethodCachedWatchMap.get(method.getDescription().methodName);
        MethodResultCacheFactory factory = this.createFactory(plasticClass, expression, method, fieldInfos, model);
        MethodAdvice advice = this.createAdvice(cacheField, factory);
        method.addAdvice(advice);
    }

    private String getFieldName(PlasticMethod method) {
        return this.getFieldName(method, FIELD_PREFIX);
    }

    private String getFieldName(PlasticMethod method, String prefix) {
        String methodName = method.getDescription().methodName;
        String className = method.getPlasticClass().getClassName();
        return this.getFieldName(prefix, methodName, className);
    }

    private String getFieldName(String prefix, String methodName, String className) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(methodName);
        if (this.multipleClassLoaders) {
            builder.append("_");
            builder.append(className.replace('.', '_'));
        }
        return builder.toString();
    }

    private MethodAdvice createAdvice(PlasticField cacheField, final MethodResultCacheFactory factory) {
        final FieldHandle fieldHandle = cacheField.getHandle();
        final String fieldName = this.multipleClassLoaders ? cacheField.getName() : null;
        return new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                MethodResultCache cache = this.getOrCreateCache(invocation);
                if (cache.isCached()) {
                    invocation.setReturnValue(cache.get());
                    return;
                }
                invocation.proceed();
                if (!invocation.didThrowCheckedException()) {
                    cache.set(invocation.getReturnValue());
                }
            }

            private MethodResultCache getOrCreateCache(MethodInvocation invocation) {
                Object instance = invocation.getInstance();
                PerThreadValue value = (PerThreadValue)(CachedWorker.this.multipleClassLoaders ? PropertyValueProvider.get((Object)instance, (String)fieldName) : fieldHandle.get(instance));
                if (value.exists()) {
                    return (MethodResultCache)value.get();
                }
                return (MethodResultCache)value.set((Object)factory.create(instance));
            }
        };
    }

    private MethodResultCacheFactory createFactory(PlasticClass plasticClass, final String watch, PlasticMethod method, Set<PlasticUtils.FieldInfo> fieldInfos, MutableComponentModel model) {
        if (watch.equals("")) {
            return this.nonWatchFactory;
        }
        final String bindingFieldName = WATCH_BINDING_PREFIX + method.getDescription().methodName;
        PlasticField bindingField = plasticClass.introduceField(Binding.class, bindingFieldName);
        final FieldHandle bindingFieldHandle = bindingField.getHandle();
        if (this.multipleClassLoaders) {
            fieldInfos.add(PlasticUtils.toFieldInfo((PlasticField)bindingField));
            try {
                bindingField.createAccessors(PropertyAccessType.READ_WRITE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        plasticClass.introduceInterface(PageLifecycleListener.class);
        plasticClass.introduceMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_DESCRIPTION).addAdvice(new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                ComponentResources resources = (ComponentResources)invocation.getInstanceContext().get(ComponentResources.class);
                Binding binding = CachedWorker.this.bindingSource.newBinding("@Cached watch", resources, "prop", watch);
                Object instance = invocation.getInstance();
                if (CachedWorker.this.multipleClassLoaders) {
                    PropertyValueProvider.set((Object)instance, (String)bindingFieldName, (Object)binding);
                } else {
                    bindingFieldHandle.set(instance, (Object)binding);
                }
                invocation.proceed();
            }
        });
        return new MethodResultCacheFactory(){

            @Override
            public MethodResultCache create(Object instance) {
                Binding binding = (Binding)(CachedWorker.this.multipleClassLoaders ? PropertyValueProvider.get((Object)instance, (String)bindingFieldName) : bindingFieldHandle.get(instance));
                return new WatchedBindingMethodResultCache(binding);
            }

            private Object getCacheBinding(String methodName, String bindingFieldName2, Object instance, ComponentModel model) {
                Object value = PropertyValueProvider.get((Object)instance, (String)bindingFieldName2);
                while (value == null && model.getParentModel() != null) {
                    model = model.getParentModel();
                    bindingFieldName2 = CachedWorker.this.getFieldName(CachedWorker.WATCH_BINDING_PREFIX, methodName, model.getComponentClassName());
                    value = PropertyValueProvider.get((Object)instance, (String)bindingFieldName2);
                }
                return value;
            }
        };
    }

    private void validateMethod(PlasticMethod method) {
        MethodDescription description = method.getDescription();
        if (description.returnType.equals("void")) {
            throw new IllegalArgumentException(String.format("Method %s may not be used with @Cached because it returns void.", method.getMethodIdentifier()));
        }
        if (description.argumentTypes.length != 0) {
            throw new IllegalArgumentException(String.format("Method %s may not be used with @Cached because it has parameters.", method.getMethodIdentifier()));
        }
    }

    private class WatchedBindingMethodResultCache
    extends SimpleMethodResultCache {
        private final Binding binding;
        private Object cachedBindingValue;

        public WatchedBindingMethodResultCache(Binding binding) {
            this.binding = binding;
        }

        @Override
        public boolean isCached() {
            Object currentBindingValue = this.binding.get();
            if (!TapestryInternalUtils.isEqual(this.cachedBindingValue, currentBindingValue)) {
                this.reset();
                this.cachedBindingValue = currentBindingValue;
            }
            return super.isCached();
        }
    }

    private class SimpleMethodResultCache
    implements MethodResultCache {
        private boolean cached;
        private Object cachedValue;

        private SimpleMethodResultCache() {
        }

        @Override
        public void set(Object cachedValue) {
            this.cached = true;
            this.cachedValue = cachedValue;
        }

        @Override
        public void reset() {
            this.cached = false;
            this.cachedValue = null;
        }

        @Override
        public boolean isCached() {
            return this.cached;
        }

        @Override
        public Object get() {
            return this.cachedValue;
        }
    }

    static interface MethodResultCacheFactory {
        public MethodResultCache create(Object var1);
    }
}

