/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tapestry5.ioc.services.ClasspathMatcher;
import org.apache.tapestry5.ioc.services.ClasspathScanner;
import org.apache.tapestry5.services.ComponentLibraryInfo;
import org.apache.tapestry5.services.ComponentLibraryInfoSource;
import org.apache.tapestry5.services.LibraryMapping;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class MavenComponentLibraryInfoSource
implements ComponentLibraryInfoSource {
    private final Logger logger;
    private final Set<String> pomPaths;
    private final Map<String, ComponentLibraryInfo> cache = new HashMap<String, ComponentLibraryInfo>();
    private final Map<String, String> pomPathToRootUrl;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public MavenComponentLibraryInfoSource(Logger logger, ClasspathScanner classpathScanner) {
        this.logger = logger;
        this.pomPaths = Collections.unmodifiableSet(MavenComponentLibraryInfoSource.findPomPaths(classpathScanner));
        this.pomPathToRootUrl = new WeakHashMap<String, String>(this.pomPaths.size());
    }

    @Override
    public ComponentLibraryInfo find(LibraryMapping libraryMapping) {
        ComponentLibraryInfo info = null;
        if (this.cache.containsKey(libraryMapping.libraryName)) {
            info = this.cache.get(libraryMapping.libraryName);
        } else {
            String pomPath = this.getPomPath(libraryMapping);
            if (pomPath != null) {
                InputStream inputStream = this.getClass().getResourceAsStream("/" + pomPath);
                info = this.parse(inputStream);
                info.setLibraryMapping(libraryMapping);
                this.cache.put(libraryMapping.libraryName, info);
            } else {
                this.cache.put(libraryMapping.libraryName, null);
            }
        }
        return info;
    }

    private ComponentLibraryInfo parse(InputStream inputStream) {
        ComponentLibraryInfo info = null;
        if (inputStream != null) {
            Document document;
            try {
                DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(inputStream);
            }
            catch (Exception e) {
                this.logger.warn("Exception while parsing pom.xml", (Throwable)e);
                return null;
            }
            info = new ComponentLibraryInfo();
            info.setGroupId(this.extractText(document, "(/project/groupId | /project/parent/groupId)[1]"));
            info.setArtifactId(this.extractText(document, "/project/artifactId"));
            info.setVersion(this.extractText(document, "/project/version"));
            info.setName(this.extractText(document, "/project/name"));
            info.setDescription(this.extractText(document, "/project/description"));
            info.setDocumentationUrl(this.extractText(document, "/project/properties/documentationUrl"));
            info.setHomepageUrl(this.extractText(document, "/project/properties/homepageUrl"));
            info.setIssueTrackerUrl(this.extractText(document, "/project/issueManagement/url"));
            info.setJavadocUrl(this.extractText(document, "/project/properties/javadocUrl"));
            info.setSourceBrowseUrl(this.extractText(document, "/project/scm/url"));
            info.setSourceRootUrl(this.extractText(document, "/project/properties/sourceRootUrl"));
            info.setTapestryVersion(this.extractText(document, "(/project/dependencies/dependency[./groupId='org.apache.tapestry'][./artifactId='tapestry-core']/version | /project/properties/tapestryVersion)[1]"));
            String tags = this.extractText(document, "/project/properties/tags");
            if (tags != null && tags.length() > 0) {
                info.setTags(Arrays.asList(tags.split(",")));
            }
        }
        return info;
    }

    private String extractText(Document document, String xpathExpression) {
        String text;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression expression = xpath.compile(xpathExpression);
            text = (String)expression.evaluate(document, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        if ("".equals(text)) {
            text = null;
        }
        return text;
    }

    private String getPomPath(LibraryMapping libraryMapping) {
        String rootPackageConverted = libraryMapping.getRootPackage().replace('.', '/');
        URL rootPackageUrl = this.getClass().getClassLoader().getResource(rootPackageConverted);
        String path = rootPackageUrl.toString();
        String url = null;
        if (path.contains("!/")) {
            path = path.substring(0, path.indexOf("!/"));
        }
        for (String pomPath : this.pomPaths) {
            if (!path.equals(this.getPomPathUrl(pomPath))) continue;
            url = pomPath;
            break;
        }
        return url;
    }

    private String getPomPathUrl(String pomPath) {
        String url = this.pomPathToRootUrl.get(pomPath);
        if (url == null) {
            for (String path : this.pomPaths) {
                URL resource = this.getClass().getResource("/" + path);
                String resourcePath = null;
                if (resource != null && resource.toString().contains("!/")) {
                    resourcePath = resource.toString();
                    resourcePath = resourcePath.substring(0, resourcePath.indexOf("!/"));
                }
                this.pomPathToRootUrl.put(path, resourcePath);
                url = resourcePath;
            }
        }
        return url;
    }

    private static Set<String> findPomPaths(ClasspathScanner classpathScanner) {
        ClasspathMatcher classpathMatcher = new ClasspathMatcher(){

            public boolean matches(String packagePath, String fileName) {
                return fileName.equals("pom.xml");
            }
        };
        try {
            return classpathScanner.scan("META-INF/maven/", classpathMatcher);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while finding pom.xml files in the classpath", e);
        }
    }
}

