/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Date;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.DateUtilities;

@SupportsInformalParameters
@Import(module={"t5/core/time-interval"})
public class TimeInterval {
    @Parameter
    Date start;
    @Parameter
    Date end;
    @Parameter
    boolean plain;
    @Inject
    ComponentResources resources;
    @Inject
    DateUtilities dateUtilities;

    private String toISO(Date date) {
        return date == null ? null : this.dateUtilities.formatISO8601(date);
    }

    boolean beginRender(MarkupWriter writer) {
        writer.element(this.resources.getElementName("span"), "data-timeinterval", "true", "data-timeinterval-start", this.toISO(this.start), "data-timeinterval-end", this.toISO(this.end));
        if (this.plain) {
            writer.attributes("data-timeinterval-plain", true);
        }
        this.resources.renderInformalParameters(writer);
        writer.end();
        return false;
    }
}

