/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.beanmodel.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.tapestry5.beanmodel.internal.services.PlasticClassListenerLogger;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.internal.services.StringLocation;
import org.apache.tapestry5.commons.internal.util.InternalCommonsUtils;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.asm.Type;
import org.apache.tapestry5.internal.plastic.asm.tree.AbstractInsnNode;
import org.apache.tapestry5.internal.plastic.asm.tree.ClassNode;
import org.apache.tapestry5.internal.plastic.asm.tree.InsnList;
import org.apache.tapestry5.internal.plastic.asm.tree.LineNumberNode;
import org.apache.tapestry5.internal.plastic.asm.tree.MethodNode;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassListener;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticManager;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.slf4j.Logger;

public class PlasticProxyFactoryImpl
implements PlasticProxyFactory {
    public static final String INTERNAL_GET_DELEGATE = "_____internalGetDelegate_DONT_CALL_THIS_METHOD_____";
    private final PlasticManager manager;
    private final Map<String, Location> memberToLocation = CollectionFactory.newConcurrentMap();

    public PlasticProxyFactoryImpl(ClassLoader parentClassLoader, Logger logger) {
        this(PlasticManager.withClassLoader((ClassLoader)parentClassLoader).create(), logger);
    }

    public PlasticProxyFactoryImpl(PlasticManager manager, Logger logger) {
        assert (manager != null);
        this.manager = manager;
        if (logger != null) {
            manager.addPlasticClassListener((PlasticClassListener)new PlasticClassListenerLogger(logger));
        }
    }

    public ClassLoader getClassLoader() {
        return this.manager.getClassLoader();
    }

    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, Class<? extends T> implementationType, PlasticClassTransformer callback) {
        return this.createProxy(interfaceType, implementationType, callback, true);
    }

    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, Class<? extends T> implementationType, PlasticClassTransformer callback, boolean introduceInterface) {
        return this.manager.createProxy(interfaceType, implementationType, callback, introduceInterface);
    }

    public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, PlasticClassTransformer callback) {
        return this.manager.createProxy(interfaceType, callback);
    }

    public <T> PlasticClassTransformation<T> createProxyTransformation(Class<T> interfaceType, Class<? extends T> implementationType) {
        return this.manager.createProxyTransformation(interfaceType, implementationType);
    }

    public <T> PlasticClassTransformation<T> createProxyTransformation(Class<T> interfaceType) {
        return this.createProxyTransformation(interfaceType, null);
    }

    public <T> T createProxy(Class<T> interfaceType, ObjectCreator<T> creator, String description) {
        return this.createProxy(interfaceType, null, creator, description);
    }

    public <T> T createProxy(final Class<T> interfaceType, Class<? extends T> implementationType, final ObjectCreator<T> creator, final String description) {
        assert (creator != null);
        assert (InternalCommonsUtils.isNonBlank((String)description));
        ClassInstantiator<? extends T> instantiator = this.createProxy(interfaceType, implementationType, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                final PlasticField objectCreatorField = plasticClass.introduceField(ObjectCreator.class, "creator").inject((Object)creator);
                String interfaceTypeName = interfaceType.getName();
                PlasticMethod delegateMethod = plasticClass.introducePrivateMethod(interfaceTypeName, "delegate", null, null);
                InstructionBuilderCallback returnCreateObject = new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().getField(objectCreatorField);
                        builder.invoke(ObjectCreator.class, Object.class, "createObject", new Class[0]);
                        builder.checkcast(interfaceType).returnResult();
                    }
                };
                delegateMethod.changeImplementation(returnCreateObject);
                for (Method method : interfaceType.getMethods()) {
                    if (Modifier.isStatic(method.getModifiers())) continue;
                    plasticClass.introduceMethod(method).delegateTo(delegateMethod);
                }
                MethodDescription getDelegateMethodDescription = new MethodDescription(interfaceType.getName(), PlasticProxyFactoryImpl.INTERNAL_GET_DELEGATE, new String[0]);
                plasticClass.introduceMethod(getDelegateMethodDescription, returnCreateObject);
                plasticClass.addToString(description);
            }
        });
        return interfaceType.cast(instantiator.newInstance());
    }

    private ClassNode readClassNode(Class clazz) {
        byte[] bytecode = PlasticInternalUtils.readBytecodeForClass((ClassLoader)this.manager.getClassLoader(), (String)clazz.getName(), (boolean)false);
        return bytecode == null ? null : PlasticInternalUtils.convertBytecodeToClassNode((byte[])bytecode);
    }

    public Location getMethodLocation(final Method method) {
        ObjectCreator<String> descriptionCreator = new ObjectCreator<String>(){

            public String createObject() {
                return InternalCommonsUtils.asString((Method)method);
            }
        };
        return this.getMemberLocation(method, method.getName(), Type.getMethodDescriptor((Method)method), descriptionCreator);
    }

    public Location getConstructorLocation(final Constructor constructor) {
        ObjectCreator<String> descriptionCreator = new ObjectCreator<String>(){

            public String createObject() {
                StringBuilder builder = new StringBuilder(constructor.getDeclaringClass().getName()).append('(');
                String sep = "";
                for (Class<?> parameterType : constructor.getParameterTypes()) {
                    builder.append(sep);
                    builder.append(parameterType.getSimpleName());
                    sep = ", ";
                }
                builder.append(')');
                return builder.toString();
            }
        };
        return this.getMemberLocation(constructor, "<init>", Type.getConstructorDescriptor((Constructor)constructor), descriptionCreator);
    }

    public void clearCache() {
        this.memberToLocation.clear();
    }

    public Location getMemberLocation(Member member, String methodName, String memberTypeDesc, ObjectCreator<String> textDescriptionCreator) {
        String className = member.getDeclaringClass().getName();
        String key = className + ":" + methodName + ":" + memberTypeDesc;
        Location location = this.memberToLocation.get(key);
        if (location == null) {
            location = this.constructMemberLocation(member, methodName, memberTypeDesc, (String)textDescriptionCreator.createObject());
            this.memberToLocation.put(key, location);
        }
        return location;
    }

    private Location constructMemberLocation(Member member, String methodName, String memberTypeDesc, String textDescription) {
        ClassNode classNode = this.readClassNode(member.getDeclaringClass());
        if (classNode == null) {
            throw new RuntimeException(String.format("Unable to read class file for %s (to gather line number information).", textDescription));
        }
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(methodName) || !mn.desc.equals(memberTypeDesc)) continue;
            int lineNumber = this.findFirstLineNumber(mn.instructions);
            if (lineNumber < 1) break;
            String description = String.format("%s (at %s:%d)", textDescription, classNode.sourceFile, lineNumber);
            return new StringLocation(description, lineNumber);
        }
        return new StringLocation(textDescription, 0);
    }

    private int findFirstLineNumber(InsnList instructions) {
        for (AbstractInsnNode node = instructions.getFirst(); node != null; node = node.getNext()) {
            if (!(node instanceof LineNumberNode)) continue;
            return ((LineNumberNode)node).line;
        }
        return -1;
    }

    public void addPlasticClassListener(PlasticClassListener listener) {
        this.manager.addPlasticClassListener(listener);
    }

    public void removePlasticClassListener(PlasticClassListener listener) {
        this.manager.removePlasticClassListener(listener);
    }

    public PlasticManager getPlasticManager() {
        return this.manager;
    }
}

