/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.internal.services.PageActivator;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.PageRenderRequestHandler;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Traditional;

public class PageRenderRequestHandlerImpl
implements PageRenderRequestHandler {
    private final RequestPageCache cache;
    private final ComponentEventResultProcessor resultProcessor;
    private final PageResponseRenderer pageResponseRenderer;
    private final PageActivator pageActivator;
    private final Request request;

    public PageRenderRequestHandlerImpl(RequestPageCache cache, @Traditional @Primary ComponentEventResultProcessor resultProcessor, PageResponseRenderer pageResponseRenderer, PageActivator pageActivator, Request request) {
        this.cache = cache;
        this.resultProcessor = resultProcessor;
        this.pageResponseRenderer = pageResponseRenderer;
        this.pageActivator = pageActivator;
        this.request = request;
    }

    @Override
    public void handle(PageRenderRequestParameters parameters) throws IOException {
        Page page = this.cache.get(parameters.getLogicalPageName());
        if (this.request.getAttribute("tapestry.bypass-page-activation") == null) {
            if (this.pageActivator.activatePage(page.getRootElement().getComponentResources(), parameters.getActivationContext(), this.resultProcessor)) {
                return;
            }
            if (!parameters.isLoopback()) {
                page.pageReset();
            }
        }
        this.pageResponseRenderer.renderPageResponse(page);
    }
}

