/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jelly;

import com.sun.script.jelly.ScriptJellyContext;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.LocationAware;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;

public class ScriptTag
extends TagSupport
implements LocationAware {
    private ScriptEngine engine;
    private String src;
    private String language;
    private String elementName;
    private String fileName;
    private int columnNumber;
    private int lineNumber;

    public ScriptTag(ScriptEngine engine) {
        this.engine = engine;
    }

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        String code = null;
        InputStreamReader reader = null;
        if (this.src != null && !this.src.equals("")) {
            reader = new InputStreamReader(this.context.getResourceAsStream(this.src));
        } else {
            code = this.getBodyText();
            if (code.equals("")) {
                return;
            }
        }
        ScriptJellyContext sjc = (ScriptJellyContext)this.context;
        ScriptContext ctx = sjc.getScriptContext();
        sjc.setScriptEngine(this.engine);
        if (this.fileName != null) {
            ctx.setAttribute("javax.script.filename", this.fileName, 100);
        }
        try {
            if (code != null) {
                this.engine.eval(code, ctx);
            } else {
                this.engine.eval((Reader)reader, ctx);
            }
        }
        catch (ScriptException e) {
            throw new JellyTagException("Error occurred with script: " + e, (Throwable)e);
        }
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }
}

