/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.listener;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeInputStream
extends InputStream {
    private static final Log log = LogFactory.getLog(CompositeInputStream.class);
    private LinkedList<InputStream> compositeIS = new LinkedList();
    private InputStream curr = null;

    public CompositeInputStream() {
    }

    public CompositeInputStream(InputStream is) {
        this.append(is);
    }

    public CompositeInputStream(InputStream[] isArray) {
        for (InputStream is : isArray) {
            this.append(is);
        }
    }

    public int read() throws IOException {
        int count = -1;
        if (this.curr != null) {
            count = this.curr.read();
        }
        if (count == -1 && this.compositeIS.size() > 0) {
            this.curr.close();
            this.curr = null;
            this.curr = this.compositeIS.removeFirst();
            count = this.curr.read();
        }
        return count;
    }

    public void append(InputStream is) {
        this.compositeIS.addLast(is);
        if (this.curr == null) {
            this.curr = this.compositeIS.removeFirst();
        }
    }

    public int available() throws IOException {
        int available = 0;
        if (this.curr != null) {
            available = this.curr.available();
        }
        if (this.compositeIS != null) {
            for (InputStream is : this.compositeIS) {
                if (is == null) continue;
                available += is.available();
            }
        }
        return available;
    }

    public void close() throws IOException {
        if (this.curr != null) {
            try {
                this.curr.close();
                this.curr = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.compositeIS != null) {
            for (InputStream is : this.compositeIS) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = -1;
        if (this.curr != null) {
            count = this.curr.read(b, off, len);
        }
        if (count < len && this.compositeIS.size() > 0) {
            this.curr.close();
            this.curr = null;
            this.curr = this.compositeIS.removeFirst();
            int numRead = count <= 0 ? 0 : count;
            int count2 = this.read(b, off + numRead, len - numRead);
            count = count2 == -1 && count == -1 ? -1 : (count2 == -1 ? numRead : count2 + numRead);
        }
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

