/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorFactory;
import org.apache.synapse.commons.executors.config.PriorityExecutorSerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;

public class PriorityExecutorDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(PriorityExecutorDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PriorityExecutor Deployment from file : " + fileName + " : Started"));
        }
        try {
            PriorityExecutor e = PriorityExecutorFactory.createExecutor((String)"http://ws.apache.org/ns/synapse", (OMElement)artifactConfig, (boolean)true, (Properties)properties);
            if (e != null) {
                e.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PriorityExecutor with name '" + e.getName() + "' has been built from the file " + fileName));
                }
                this.getSynapseConfiguration().addPriorityExecutor(e.getName(), e);
                e.init();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PriorityExecutor Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("PriorityExecutor named '" + e.getName() + "' has been deployed from file : " + fileName));
                return e.getName();
            }
            this.handleSynapseArtifactDeploymentError("PriorityExecutor Deployment Failed. The artifact described in the file " + fileName + " is not a PriorityExecutor");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("PriorityExecutor Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PriorityExecutor update from file : " + fileName + " has started"));
        }
        try {
            PriorityExecutor e = PriorityExecutorFactory.createExecutor((String)"http://ws.apache.org/ns/synapse", (OMElement)artifactConfig, (boolean)true, (Properties)properties);
            if (e == null) {
                this.handleSynapseArtifactDeploymentError("PriorityExecutor update failed. The artifact defined in the file: " + fileName + " is not a valid executor.");
                return null;
            }
            e.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executor: " + e.getName() + " has been built from the file: " + fileName));
            }
            e.init();
            PriorityExecutor existingExecutor = this.getSynapseConfiguration().getPriorityExecutors().get(existingArtifactName);
            if (existingArtifactName.equals(e.getName())) {
                this.getSynapseConfiguration().updatePriorityExecutor(existingArtifactName, e);
            } else {
                this.getSynapseConfiguration().addPriorityExecutor(e.getName(), e);
                this.getSynapseConfiguration().removeExecutor(existingArtifactName);
                log.info((Object)("Executor: " + existingArtifactName + " has been undeployed"));
            }
            this.waitForCompletion();
            existingExecutor.destroy();
            log.info((Object)("PriorityExecutor: " + e.getName() + " has been updated from the file: " + fileName));
            return e.getName();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the executor from the file: " + fileName);
        }
        catch (AxisFault e) {
            this.handleSynapseArtifactDeploymentError("Error while creating the executor from the configuration in file: " + fileName);
        }
        return null;
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PriorityExecutor Undeployment of the entry named : " + artifactName + " : Started"));
        }
        try {
            PriorityExecutor e = this.getSynapseConfiguration().getPriorityExecutors().get(artifactName);
            if (e != null) {
                e = this.getSynapseConfiguration().removeExecutor(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PriorityExecutor Undeployment of the entry named : " + artifactName + " : Completed"));
                }
                e.destroy();
                log.info((Object)("PriorityExecutor named '" + e.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("PriorityExecutor " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("PriorityExecutor Undeployement of entry named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring PriorityExecutor with name : " + artifactName + " : Started"));
        }
        try {
            PriorityExecutor e = this.getSynapseConfiguration().getPriorityExecutors().get(artifactName);
            OMElement entryElem = PriorityExecutorSerializer.serialize(null, (PriorityExecutor)e, (String)"http://ws.apache.org/ns/synapse");
            if (e.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "priority-executors" + File.separator + e.getFileName();
                this.writeToFile(entryElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the PriorityExecutor with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("PriorityExecutor named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the PriorityExecutor named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the PriorityExecutor named '" + artifactName + "' has failed", e);
        }
    }
}

