/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.elementary.EnrichMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.jaxen.JaxenException;

public class EnrichMediatorFactory
extends AbstractMediatorFactory {
    private static final QName XML_Q = new QName("http://ws.apache.org/ns/synapse", "enrich");
    private static final QName ATT_PROPERTY = new QName("property");
    private static final QName ATT_XPATH = new QName("xpath");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName ATT_CLONE = new QName("clone");
    private static final QName ATT_ACTION = new QName("action");
    public static final QName SOURCE_Q = new QName("http://ws.apache.org/ns/synapse", "source");
    public static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");
    public static final String CUSTOM = "custom";
    public static final String PROPERTY = "property";
    public static final String ENVELOPE = "envelope";
    public static final String BODY = "body";
    public static final String INLINE = "inline";

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        if (!XML_Q.equals(elem.getQName())) {
            this.handleException("Unable to create the enrich mediator. Unexpected element as the enrich mediator configuration");
        }
        EnrichMediator enrich = new EnrichMediator();
        OMElement sourceEle = elem.getFirstChildWithName(SOURCE_Q);
        if (sourceEle == null) {
            this.handleException("source element is mandatory");
        }
        Source source = new Source();
        enrich.setSource(source);
        OMElement targetEle = elem.getFirstChildWithName(TARGET_Q);
        if (targetEle == null) {
            this.handleException("target element is mandatory");
        }
        Target target = new Target();
        enrich.setTarget(target);
        this.populateSource(source, sourceEle);
        this.populateTarget(target, targetEle);
        return enrich;
    }

    private void populateSource(Source source, OMElement sourceEle) {
        OMAttribute cloneAttr;
        OMAttribute typeAttr = sourceEle.getAttribute(ATT_TYPE);
        if (typeAttr != null && typeAttr.getAttributeValue() != null) {
            source.setSourceType(this.convertTypeToInit(typeAttr.getAttributeValue()));
        }
        if ((cloneAttr = sourceEle.getAttribute(ATT_CLONE)) != null && cloneAttr.getAttributeValue() != null) {
            source.setClone(Boolean.parseBoolean(cloneAttr.getAttributeValue()));
        }
        if (source.getSourceType() == 0) {
            OMAttribute xpathAttr = sourceEle.getAttribute(ATT_XPATH);
            if (xpathAttr != null && xpathAttr.getAttributeValue() != null) {
                try {
                    source.setXpath(SynapseXPathFactory.getSynapseXPath(sourceEle, ATT_XPATH));
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression: " + xpathAttr);
                }
            } else {
                this.handleException("xpath attribute is required for CUSTOM type");
            }
        } else if (source.getSourceType() == 3) {
            OMAttribute propertyAttr = sourceEle.getAttribute(ATT_PROPERTY);
            if (propertyAttr != null && propertyAttr.getAttributeValue() != null) {
                source.setProperty(propertyAttr.getAttributeValue());
            } else {
                this.handleException("xpath attribute is required for CUSTOM type");
            }
        } else if (source.getSourceType() == 4) {
            OMElement inlineElem = null;
            if (sourceEle.getFirstElement() != null) {
                inlineElem = sourceEle.getFirstElement().cloneOMElement();
            }
            if (inlineElem != null) {
                source.setInlineOMNode((OMNode)inlineElem);
            } else if (sourceEle.getText() != null && !sourceEle.getText().equals("")) {
                source.setInlineOMNode((OMNode)OMAbstractFactory.getOMFactory().createOMText(sourceEle.getText()));
            } else if (sourceEle.getAttributeValue(ATT_KEY) != null) {
                source.setInlineKey(sourceEle.getAttributeValue(ATT_KEY));
            } else {
                this.handleException("XML element is required for INLINE type");
            }
        }
    }

    private void populateTarget(Target target, OMElement sourceEle) {
        OMAttribute actionAttr;
        OMAttribute typeAttr = sourceEle.getAttribute(ATT_TYPE);
        if (typeAttr != null && typeAttr.getAttributeValue() != null) {
            int type = this.convertTypeToInit(typeAttr.getAttributeValue());
            if (type >= 0) {
                target.setTargetType(type);
            } else {
                this.handleException("Un-expected type : " + typeAttr.getAttributeValue());
            }
        }
        if ((actionAttr = sourceEle.getAttribute(ATT_ACTION)) != null && actionAttr.getAttributeValue() != null) {
            target.setAction(actionAttr.getAttributeValue());
        }
        if (target.getTargetType() == 0) {
            OMAttribute xpathAttr = sourceEle.getAttribute(ATT_XPATH);
            if (xpathAttr != null && xpathAttr.getAttributeValue() != null) {
                try {
                    target.setXpath(SynapseXPathFactory.getSynapseXPath(sourceEle, ATT_XPATH));
                }
                catch (JaxenException e) {
                    this.handleException("Invalid XPath expression: " + xpathAttr);
                }
            } else {
                this.handleException("xpath attribute is required for CUSTOM type");
            }
        } else if (target.getTargetType() == 3) {
            OMAttribute propertyAttr = sourceEle.getAttribute(ATT_PROPERTY);
            if (propertyAttr != null && propertyAttr.getAttributeValue() != null) {
                target.setProperty(propertyAttr.getAttributeValue());
            } else {
                this.handleException("property attribute is required for property type");
            }
        }
    }

    private int convertTypeToInit(String type) {
        if (type.equals(ENVELOPE)) {
            return 1;
        }
        if (type.equals(BODY)) {
            return 2;
        }
        if (type.equals(PROPERTY)) {
            return 3;
        }
        if (type.equals(CUSTOM)) {
            return 0;
        }
        if (type.equals(INLINE)) {
            return 4;
        }
        return -1;
    }

    @Override
    public QName getTagQName() {
        return XML_Q;
    }
}

