/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestedAuthnContextSchemaValidator
implements Validator<RequestedAuthnContext> {
    public void validate(RequestedAuthnContext requestedAuthnContext) throws ValidationException {
        this.validateChildren(requestedAuthnContext);
    }

    protected void validateChildren(RequestedAuthnContext rac) throws ValidationException {
        int classRefCount = rac.getAuthnContextClassRefs().size();
        int declRefCount = rac.getAuthnContextDeclRefs().size();
        if (classRefCount == 0 && declRefCount == 0) {
            throw new ValidationException("At least one of either AuthnContextClassRef or AuthnContextDeclRef is required");
        }
        if (classRefCount > 0 && declRefCount > 0) {
            throw new ValidationException("AuthnContextClassRef and AuthnContextDeclRef are mutually exclusive");
        }
    }
}

