/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsRecord;
import org.apache.synapse.aspects.statistics.StatisticsUpdateStrategy;
import org.apache.synapse.aspects.statistics.view.InOutStatisticsView;
import org.apache.synapse.aspects.statistics.view.StatisticsViewStrategy;

public class SystemViewStrategy
implements StatisticsViewStrategy {
    private static final Log log = LogFactory.getLog(SystemViewStrategy.class);

    @Override
    public Map<String, Map<String, InOutStatisticsView>> determineView(List<StatisticsRecord> statisticsRecords, ComponentType type) {
        HashMap<String, Map<String, InOutStatisticsView>> statisticsMap = new HashMap<String, Map<String, InOutStatisticsView>>();
        if (statisticsRecords == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Statistics records cannot be found.");
            }
            return statisticsMap;
        }
        HashMap<String, InOutStatisticsView> perResourceMap = new HashMap<String, InOutStatisticsView>();
        for (StatisticsRecord record : statisticsRecords) {
            if (record == null) continue;
            StatisticsUpdateStrategy strategy = new StatisticsUpdateStrategy(record);
            Iterator<String> logIds = record.getAllLogIds(type);
            while (logIds.hasNext()) {
                InOutStatisticsView view;
                String id = logIds.next();
                if (!perResourceMap.containsKey(id)) {
                    view = new InOutStatisticsView(id, "all", type);
                    perResourceMap.put(id, view);
                } else {
                    view = (InOutStatisticsView)perResourceMap.get(id);
                }
                this.updateStatistics(id, type, view, strategy);
            }
        }
        statisticsMap.put("all", perResourceMap);
        return statisticsMap;
    }

    @Override
    public Map<String, InOutStatisticsView> determineView(String id, List<StatisticsRecord> statisticsRecords, ComponentType type) {
        if (id == null || "".equals(id)) {
            SystemViewStrategy.handleException("Resource Id cannot be null");
        }
        HashMap<String, InOutStatisticsView> statisticsMap = new HashMap<String, InOutStatisticsView>();
        if (statisticsRecords == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Statistics records cannot be found.");
            }
            return statisticsMap;
        }
        InOutStatisticsView view = new InOutStatisticsView(id, "all", type);
        for (StatisticsRecord record : statisticsRecords) {
            if (record == null) continue;
            this.updateStatistics(id, type, view, new StatisticsUpdateStrategy(record));
        }
        statisticsMap.put("all", view);
        return statisticsMap;
    }

    private void updateStatistics(String id, ComponentType type, InOutStatisticsView view, StatisticsUpdateStrategy strategy) {
        if (view != null) {
            strategy.updateStatistics(id, type, view);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

