/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.synapse.transport.passthru.HttpGetRequestProcessor;
import org.apache.synapse.transport.passthru.config.BaseConfiguration;
import org.apache.synapse.transport.passthru.connections.SourceConnections;

public class SourceConfiguration
extends BaseConfiguration {
    private Log log = LogFactory.getLog(SourceConfiguration.class);
    private HttpResponseFactory responseFactory = null;
    private int port = 8280;
    private String bindAddress = null;
    private SourceConnections sourceConnections = null;
    private String host;
    private String transportName;
    private String serviceEPRPrefix;
    private String customEPRPrefix;
    private boolean ssl = false;
    private HttpGetRequestProcessor httpGetRequestProcessor = null;

    public SourceConfiguration(ConfigurationContext configurationContext, TransportInDescription description, WorkerPool pool, boolean ssl) throws AxisFault {
        super(configurationContext, (ParameterInclude)description, pool);
        Parameter hostParameter;
        this.transportName = description.getName();
        this.ssl = ssl;
        this.responseFactory = new DefaultHttpResponseFactory();
        this.sourceConnections = new SourceConnections();
        this.port = ParamUtils.getRequiredParamInt((ParameterInclude)this.parameters, (String)"port");
        Parameter bindAddressParameter = this.parameters.getParameter("bind-address");
        if (bindAddressParameter != null) {
            this.bindAddress = ((String)bindAddressParameter.getValue()).trim();
        }
        if ((hostParameter = this.parameters.getParameter("hostname")) != null) {
            this.host = ((String)hostParameter.getValue()).trim();
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)"Unable to lookup local host name, using 'localhost'");
            }
        }
        Parameter param = this.parameters.getParameter("WSDLEPRPrefix");
        if (param != null) {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(configurationContext, (String)param.getValue());
            this.customEPRPrefix = (String)param.getValue();
        } else {
            this.serviceEPRPrefix = this.getServiceEPRPrefix(configurationContext, this.host, this.port);
            this.customEPRPrefix = this.transportName + "://" + this.host + ":" + (this.port == 80 ? "" : Integer.valueOf(this.port)) + "/";
        }
        param = this.parameters.getParameter("httpGetProcessor");
        if (param != null && param.getValue() != null) {
            this.httpGetRequestProcessor = this.createHttpGetProcessor(param.getValue().toString());
            if (this.httpGetRequestProcessor == null) {
                this.handleException("Cannot create HttpGetRequestProcessor");
            }
        }
    }

    @Override
    protected HttpProcessor initHttpProcessor() {
        String server = this.conf.getStringProperty("http.server.value", "Synapse-PT-HttpComponents-NIO");
        return new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(server), new ResponseContent(), new ResponseConnControl()});
    }

    public HttpResponseFactory getResponseFactory() {
        return this.responseFactory;
    }

    public int getPort() {
        return this.port;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public SourceConnections getSourceConnections() {
        return this.sourceConnections;
    }

    public String getTransportName() {
        return this.transportName;
    }

    public String getServiceEPRPrefix() {
        return this.serviceEPRPrefix;
    }

    public String getCustomEPRPrefix() {
        return this.customEPRPrefix;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public HttpGetRequestProcessor getHttpGetRequestProcessor() {
        return this.httpGetRequestProcessor;
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String wsdlEPRPrefix) {
        return wsdlEPRPrefix + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        if (!this.ssl) {
            return "http://" + host + (port == 80 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
        }
        return "https://" + host + (port == 443 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    private HttpGetRequestProcessor createHttpGetProcessor(String str) throws AxisFault {
        Object obj = null;
        try {
            obj = Class.forName(str).newInstance();
        }
        catch (ClassNotFoundException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (InstantiationException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        catch (IllegalAccessException e) {
            this.handleException("Error creating WSDL processor", e);
        }
        if (obj instanceof HttpGetRequestProcessor) {
            return obj;
        }
        this.handleException("Error creating WSDL processor. The HttpProcessor should be of type org.apache.synapse.transport.nhttp.HttpGetRequestProcessor");
        return null;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        this.log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

