/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;
import java.util.regex.Pattern;

public final class AttributeValidator
implements Serializable {
    private final String name;
    private final String contentType;
    private final Pattern pattern;
    private final ImmutableSet<Flag> flags;
    private final String defaultValue;
    private final String example;

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isValidValue(String value) {
        return this.pattern == null || this.pattern.matcher(value).matches();
    }

    public boolean isFlagSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getExample() {
        return this.example;
    }

    public AttributeValidator(String name, String contentType, Pattern pattern, Set<Flag> flags, String defaultValue, String example) {
        this.name = Preconditions.checkNotNull(name);
        this.contentType = contentType;
        this.pattern = pattern;
        this.flags = ImmutableSet.copyOf(flags);
        this.defaultValue = defaultValue;
        this.example = example;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof AttributeValidator && this.equals((AttributeValidator)that);
    }

    public boolean equals(AttributeValidator that) {
        String p1 = this.pattern == null ? null : this.pattern.pattern();
        String p2 = that.pattern == null ? null : that.pattern.pattern();
        return Objects.equal(this.name, that.name) && Objects.equal(this.contentType, that.contentType) && Objects.equal(p1, p2) && Objects.equal(this.flags, that.flags) && Objects.equal(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        String patternString = this.pattern == null ? null : this.pattern.pattern();
        return Objects.hashCode(this.name, this.contentType, patternString, this.flags, this.defaultValue);
    }

    public static enum Flag {
        BOOLEAN,
        DEPRECATED,
        FRAMESETDTD,
        LOOSEDTD,
        REQUIRED,
        VISIBLETEXT,
        NONSTANDARD,
        INTERNAL_ONLY;

    }
}

