/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.compiler.fs.AbstractFileSystem;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public final class SystemFileSystem
extends AbstractFileSystem {
    public static final SystemFileSystem INSTANCE = new SystemFileSystem();
    private final FileStore store = new FileStore(){

        @Override
        public Charset getDefaultCharset() {
            return SystemFileSystem.this.getDefaultCharset();
        }

        @Override
        public URI toUri(FileRef fileRef) {
            try {
                return new URI("file", null, fileRef.getName(), null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public InputStream openInputStream(FileRef fileRef) throws IOException {
            return new FileInputStream(SystemFileSystem.fileRefToFile(fileRef));
        }

        @Override
        public OutputStream openOutputStream(FileRef fileRef) throws IOException {
            File file = SystemFileSystem.fileRefToFile(fileRef);
            file.getParentFile().mkdirs();
            return new FileOutputStream(file);
        }

        @Override
        public String toFilename(FileRef fileRef) {
            return SystemFileSystem.fileRefToFile(fileRef).getPath();
        }

        @Override
        public String toRelativeFilename(FileRef fileRef) {
            String cwd;
            String filename = this.toFilename(fileRef);
            return filename.startsWith(cwd = SystemFileSystem.this.getCwd().toFilename()) ? filename.substring(cwd.length() + 1) : filename;
        }

        @Override
        public long getLastModified(FileRef fileRef) {
            return SystemFileSystem.fileRefToFile(fileRef).lastModified();
        }

        @Override
        public boolean delete(FileRef fileRef) {
            return SystemFileSystem.fileRefToFile(fileRef).delete();
        }
    };
    private static Pattern PATH_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(File.pathSeparator));

    private SystemFileSystem() {
    }

    @Override
    protected FileStore getFileStore() {
        return this.store;
    }

    private static File fileRefToFile(FileRef fileRef) {
        return new File(fileRef.toUri());
    }

    @Override
    public FileRef parseFilename(String filename) {
        return new FileRef(this.store, this.filenameToFile(filename).toURI().getPath());
    }

    public FileRef getCwd() {
        return this.parseFilename(System.getProperty("user.dir"));
    }

    private File filenameToFile(String filename) {
        return new File(filename).getAbsoluteFile();
    }

    @Override
    protected Pattern getFilenameListDelimiter() {
        return PATH_SEPARATOR_PATTERN;
    }
}

