/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileStore;
import com.google.gxp.compiler.fs.FileSystem;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractFileSystem
implements FileSystem {
    protected abstract FileStore getFileStore();

    protected abstract Pattern getFilenameListDelimiter();

    @Override
    public final FileRef getRoot() {
        return new FileRef(this.getFileStore(), "/");
    }

    @Override
    public final List<FileRef> parseFilenameList(String filenameList) {
        String[] filenames = this.getFilenameListDelimiter().split(filenameList, -1);
        ArrayList<FileRef> result = Lists.newArrayListWithExpectedSize(filenames.length);
        for (int i = 0; i < filenames.length; ++i) {
            result.add(this.parseFilename(filenames[i]));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Charset getDefaultCharset() {
        throw new UnsupportedOperationException();
    }
}

