/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.Node;

public class ConstructedConstant
extends Expression {
    private final String value;
    private final Callable callee;
    private final FormalParameter param;

    public ConstructedConstant(Node fromNode, String value, Callable callee, FormalParameter param) {
        super(fromNode, null);
        this.value = Preconditions.checkNotNull(value);
        this.callee = Preconditions.checkNotNull(callee);
        this.param = Preconditions.checkNotNull(param);
    }

    public String getValue() {
        return this.value;
    }

    public Callable getCallee() {
        return this.callee;
    }

    public FormalParameter getParam() {
        return this.param;
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitConstructedConstant(this);
    }

    public String toString() {
        return this.getDisplayName() + "=ConstructedConstant@" + this.getSourcePosition() + "(\"" + CharEscapers.javaStringEscaper().escape(this.getValue()) + "\")";
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ConstructedConstant && this.equals((ConstructedConstant)that);
    }

    public boolean equals(ConstructedConstant that) {
        return this.equalsExpression(that) && this.value.equals(that.value) && this.callee.equals(that.callee) && this.param.equals(that.param);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.value, this.callee, this.param);
    }
}

