/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.MemberOfEnum;
import net.sf.oval.exception.OValException;
import net.sf.oval.internal.util.StringUtils;

public class MemberOfEnumCheck
extends AbstractAnnotationCheck<MemberOfEnum> {
    private static final long serialVersionUID = 1L;
    private Class<? extends Enum<?>> constraintEnum;
    private Set<String> enumValues = Collections.emptySet();
    private boolean ignoreCase;

    @Override
    public void configure(MemberOfEnum constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setConstraintEnum(constraintAnnotation.value());
        this.setIgnoreCase(constraintAnnotation.ignoreCase());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("members", StringUtils.join(this.constraintEnum.getEnumConstants(), ','));
        return messageVariables;
    }

    public Class<? extends Enum<?>> getConstraintEnum() {
        return this.constraintEnum;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) throws OValException {
        if (Objects.isNull(valueToValidate)) {
            return true;
        }
        if (this.ignoreCase) {
            return this.enumValues.contains(valueToValidate.toString().toLowerCase());
        }
        return this.enumValues.contains(valueToValidate.toString());
    }

    public void setConstraintEnum(Class<? extends Enum<?>> constraintEnum) {
        this.constraintEnum = constraintEnum;
        Enum<?>[] enumValues = constraintEnum.getEnumConstants();
        Set enumValuesSet = Validator.getCollectionFactory().createSet(enumValues.length);
        Enum<?>[] enumArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> enumValue = enumArray[n2];
            if (this.ignoreCase) {
                enumValuesSet.add(enumValue.toString().toLowerCase());
            } else {
                enumValuesSet.add(enumValue.toString());
            }
            ++n2;
        }
        this.enumValues = enumValuesSet;
        this.requireMessageVariablesRecreation();
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

