/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.oval.AbstractCheck;
import net.sf.oval.Check;
import net.sf.oval.CheckExclusion;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.configuration.CheckInitializationListener;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.configuration.annotation.Constraint;
import net.sf.oval.configuration.pojo.POJOConfigurer;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPostExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPreExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ObjectConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.configuration.xml.XIncludeAwareDOMDriver;
import net.sf.oval.constraint.AssertCheck;
import net.sf.oval.constraint.AssertConstraintSetCheck;
import net.sf.oval.constraint.AssertFalseCheck;
import net.sf.oval.constraint.AssertFieldConstraintsCheck;
import net.sf.oval.constraint.AssertNullCheck;
import net.sf.oval.constraint.AssertTrueCheck;
import net.sf.oval.constraint.AssertURLCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.CheckWithCheck;
import net.sf.oval.constraint.DateRangeCheck;
import net.sf.oval.constraint.DigitsCheck;
import net.sf.oval.constraint.EmailCheck;
import net.sf.oval.constraint.EqualToFieldCheck;
import net.sf.oval.constraint.FutureCheck;
import net.sf.oval.constraint.HasSubstringCheck;
import net.sf.oval.constraint.InstanceOfAnyCheck;
import net.sf.oval.constraint.InstanceOfCheck;
import net.sf.oval.constraint.LengthCheck;
import net.sf.oval.constraint.MatchPatternCheck;
import net.sf.oval.constraint.MaxCheck;
import net.sf.oval.constraint.MaxLengthCheck;
import net.sf.oval.constraint.MaxSizeCheck;
import net.sf.oval.constraint.MemberOfCheck;
import net.sf.oval.constraint.MinCheck;
import net.sf.oval.constraint.MinLengthCheck;
import net.sf.oval.constraint.MinSizeCheck;
import net.sf.oval.constraint.NoSelfReferenceCheck;
import net.sf.oval.constraint.NotBlankCheck;
import net.sf.oval.constraint.NotEmptyCheck;
import net.sf.oval.constraint.NotEqualCheck;
import net.sf.oval.constraint.NotEqualToFieldCheck;
import net.sf.oval.constraint.NotMatchPatternCheck;
import net.sf.oval.constraint.NotMemberOfCheck;
import net.sf.oval.constraint.NotNegativeCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.PastCheck;
import net.sf.oval.constraint.RangeCheck;
import net.sf.oval.constraint.SizeCheck;
import net.sf.oval.constraint.ValidateWithMethodCheck;
import net.sf.oval.constraint.exclusion.NullableExclusion;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.ReflectionUtils;

public class XMLConfigurer
implements Configurer {
    private static final ThreadLocal<Collection<CheckInitializationListener>> CURRENT_LISTENERS = new ThreadLocal();
    protected final Set<CheckInitializationListener> listeners = new LinkedHashSet<CheckInitializationListener>(2);
    private POJOConfigurer pojoConfigurer = new POJOConfigurer();
    private final XStream xStream;

    public static XStream createXStream() {
        XStream xStream = new XStream((ReflectionProvider)new XStreamReflectionProvider(), (HierarchicalStreamDriver)new XIncludeAwareDOMDriver());
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByWildcard(new String[]{"net.sf.oval.**"});
        xStream.registerConverter((Converter)new ReflectionConverter(xStream.getMapper(), xStream.getReflectionProvider()){

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                Object instance = super.unmarshal(reader, context);
                if (instance instanceof Check) {
                    XMLConfigurer.onCheckInitialized((Check)instance);
                }
                return instance;
            }
        }, -20);
        xStream.registerConverter((Converter)new ListConverter(xStream.getMapper()));
        xStream.registerConverter((Converter)new AssertCheckConverter());
        xStream.registerConverter((Converter)new PatternConverter());
        xStream.omitField(AbstractCheck.class, "messageVariablesUpToDate");
        xStream.useAttributeFor(Class.class);
        xStream.useAttributeFor(Boolean.TYPE);
        xStream.useAttributeFor(Byte.TYPE);
        xStream.useAttributeFor(Character.TYPE);
        xStream.useAttributeFor(Double.TYPE);
        xStream.useAttributeFor(Float.TYPE);
        xStream.useAttributeFor(Integer.TYPE);
        xStream.useAttributeFor(Long.TYPE);
        xStream.useAttributeFor(Boolean.class);
        xStream.useAttributeFor(Byte.class);
        xStream.useAttributeFor(Character.class);
        xStream.useAttributeFor(Double.class);
        xStream.useAttributeFor(Float.class);
        xStream.useAttributeFor(Integer.class);
        xStream.useAttributeFor(Long.class);
        xStream.useAttributeFor(String.class);
        xStream.alias("java-type", Class.class);
        xStream.alias("constraintTarget", ConstraintTarget.class);
        xStream.alias("assert", AssertCheck.class);
        xStream.alias("assertConstraintSet", AssertConstraintSetCheck.class);
        xStream.alias("assertFalse", AssertFalseCheck.class);
        xStream.alias("assertFieldConstraints", AssertFieldConstraintsCheck.class);
        xStream.alias("assertNull", AssertNullCheck.class);
        xStream.alias("assertTrue", AssertTrueCheck.class);
        xStream.alias("assertURL", AssertURLCheck.class);
        xStream.alias("permittedURIScheme", AssertURLCheck.URIScheme.class);
        xStream.addImplicitCollection(AssertURLCheck.class, "permittedURISchemes", AssertURLCheck.URIScheme.class);
        xStream.alias("assertValid", AssertValidCheck.class);
        xStream.alias("checkWith", CheckWithCheck.class);
        xStream.alias("dateRange", DateRangeCheck.class);
        xStream.alias("digits", DigitsCheck.class);
        xStream.alias("email", EmailCheck.class);
        xStream.alias("equalToField", EqualToFieldCheck.class);
        xStream.alias("future", FutureCheck.class);
        xStream.alias("hasSubstring", HasSubstringCheck.class);
        xStream.alias("instanceOf", InstanceOfCheck.class);
        xStream.alias("instanceOfAny", InstanceOfAnyCheck.class);
        xStream.alias("length", LengthCheck.class);
        xStream.alias("matchPattern", MatchPatternCheck.class);
        xStream.alias("pattern", Pattern.class);
        xStream.addImplicitCollection(MatchPatternCheck.class, "patterns", Pattern.class);
        xStream.alias("max", MaxCheck.class);
        xStream.alias("maxLength", MaxLengthCheck.class);
        xStream.alias("maxSize", MaxSizeCheck.class);
        xStream.alias("memberOf", MemberOfCheck.class);
        xStream.alias("min", MinCheck.class);
        xStream.alias("minLength", MinLengthCheck.class);
        xStream.alias("minSize", MinSizeCheck.class);
        xStream.alias("noSelfReference", NoSelfReferenceCheck.class);
        xStream.alias("notBlank", NotBlankCheck.class);
        xStream.alias("notEmpty", NotEmptyCheck.class);
        xStream.alias("notEqual", NotEqualCheck.class);
        xStream.alias("notEqualToField", NotEqualToFieldCheck.class);
        xStream.alias("notMatchPattern", NotMatchPatternCheck.class);
        xStream.addImplicitCollection(NotMatchPatternCheck.class, "patterns", Pattern.class);
        xStream.alias("notMemberOf", NotMemberOfCheck.class);
        xStream.alias("notNegative", NotNegativeCheck.class);
        xStream.alias("notNull", NotNullCheck.class);
        xStream.alias("past", PastCheck.class);
        xStream.alias("range", RangeCheck.class);
        xStream.alias("simpleCheck", CheckWithCheck.SimpleCheck.class);
        xStream.alias("size", SizeCheck.class);
        xStream.alias("validateWithMethod", ValidateWithMethodCheck.class);
        xStream.omitField(ValidateWithMethodCheck.class, "validationMethodsByClass");
        xStream.alias("nullable", NullableExclusion.class);
        xStream.alias("oval", POJOConfigurer.class);
        xStream.addImplicitCollection(POJOConfigurer.class, "constraintSetConfigurations", ConstraintSetConfiguration.class);
        xStream.alias("constraintSet", ConstraintSetConfiguration.class);
        xStream.addImplicitCollection(ConstraintSetConfiguration.class, "checks");
        xStream.addImplicitCollection(POJOConfigurer.class, "classConfigurations", ClassConfiguration.class);
        xStream.alias("class", ClassConfiguration.class);
        xStream.aliasField("object", ClassConfiguration.class, "objectConfiguration");
        xStream.addImplicitCollection(ObjectConfiguration.class, "checks");
        xStream.addImplicitCollection(ClassConfiguration.class, "fieldConfigurations", FieldConfiguration.class);
        xStream.alias("field", FieldConfiguration.class);
        xStream.addImplicitCollection(FieldConfiguration.class, "checks");
        xStream.alias("parameter", ParameterConfiguration.class);
        xStream.addImplicitCollection(ParameterConfiguration.class, "checks", Check.class);
        xStream.addImplicitCollection(ParameterConfiguration.class, "checkExclusions", CheckExclusion.class);
        xStream.addImplicitCollection(ClassConfiguration.class, "constructorConfigurations", ConstructorConfiguration.class);
        xStream.alias("constructor", ConstructorConfiguration.class);
        xStream.addImplicitCollection(ConstructorConfiguration.class, "parameterConfigurations", ParameterConfiguration.class);
        xStream.addImplicitCollection(ClassConfiguration.class, "methodConfigurations", MethodConfiguration.class);
        xStream.alias("method", MethodConfiguration.class);
        xStream.addImplicitCollection(MethodConfiguration.class, "parameterConfigurations", ParameterConfiguration.class);
        xStream.aliasField("returnValue", MethodConfiguration.class, "returnValueConfiguration");
        xStream.addImplicitCollection(MethodReturnValueConfiguration.class, "checks", Check.class);
        xStream.aliasField("preExecution", MethodConfiguration.class, "preExecutionConfiguration");
        xStream.addImplicitCollection(MethodPreExecutionConfiguration.class, "checks", PreCheck.class);
        xStream.alias("pre", PreCheck.class);
        xStream.aliasField("postExecution", MethodConfiguration.class, "postExecutionConfiguration");
        xStream.addImplicitCollection(MethodPostExecutionConfiguration.class, "checks", PostCheck.class);
        xStream.alias("post", PostCheck.class);
        return xStream;
    }

    protected static void onCheckInitialized(Check check) {
        Collection<CheckInitializationListener> listeners = CURRENT_LISTENERS.get();
        if (listeners != null) {
            for (CheckInitializationListener listener : listeners) {
                listener.onCheckInitialized(check);
            }
        }
    }

    public XMLConfigurer() {
        this.xStream = XMLConfigurer.createXStream();
    }

    public XMLConfigurer(File xmlConfigFile) {
        this();
        this.fromXML(xmlConfigFile);
    }

    public XMLConfigurer(InputStream xmlConfigStream) {
        this();
        this.fromXML(xmlConfigStream);
    }

    public XMLConfigurer(Reader xmlConfigReader) {
        this();
        this.fromXML(xmlConfigReader);
    }

    public XMLConfigurer(String xmlConfigAsString) {
        this();
        this.fromXML(xmlConfigAsString);
    }

    public XMLConfigurer(XStream xStream) {
        this.xStream = xStream == null ? XMLConfigurer.createXStream() : xStream;
    }

    public XMLConfigurer(XStream xStream, File xmlConfigFile) {
        this(xStream);
        this.fromXML(xmlConfigFile);
    }

    public XMLConfigurer(XStream xStream, InputStream xmlConfigStream) {
        this(xStream);
        this.fromXML(xmlConfigStream);
    }

    public XMLConfigurer(XStream xStream, Reader xmlConfigReader) {
        this(xStream);
        this.fromXML(xmlConfigReader);
    }

    public XMLConfigurer(XStream xStream, String xmlConfigAsString) {
        this(xStream);
        this.fromXML(xmlConfigAsString);
    }

    public boolean addCheckInitializationListener(CheckInitializationListener listener) {
        Assert.argumentNotNull("listener", listener);
        return this.listeners.add(listener);
    }

    public void fromXML(File input) {
        CURRENT_LISTENERS.set(this.listeners);
        try {
            this.pojoConfigurer = (POJOConfigurer)this.xStream.fromXML(input);
        }
        finally {
            CURRENT_LISTENERS.remove();
        }
    }

    public void fromXML(InputStream input) {
        CURRENT_LISTENERS.set(this.listeners);
        try {
            this.pojoConfigurer = (POJOConfigurer)this.xStream.fromXML(input);
        }
        finally {
            CURRENT_LISTENERS.remove();
        }
    }

    public void fromXML(Reader input) {
        CURRENT_LISTENERS.set(this.listeners);
        try {
            this.pojoConfigurer = (POJOConfigurer)this.xStream.fromXML(input);
        }
        finally {
            CURRENT_LISTENERS.remove();
        }
    }

    public void fromXML(String input) {
        CURRENT_LISTENERS.set(this.listeners);
        try {
            this.pojoConfigurer = (POJOConfigurer)this.xStream.fromXML(input);
        }
        finally {
            CURRENT_LISTENERS.remove();
        }
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) throws InvalidConfigurationException {
        return this.pojoConfigurer.getClassConfiguration(clazz);
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) throws InvalidConfigurationException {
        return this.pojoConfigurer.getConstraintSetConfiguration(constraintSetId);
    }

    public POJOConfigurer getPojoConfigurer() {
        return this.pojoConfigurer;
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public boolean removeCheckInitializationListener(CheckInitializationListener listener) {
        return this.listeners.remove(listener);
    }

    public void setPojoConfigurer(POJOConfigurer pojoConfigurer) {
        this.pojoConfigurer = pojoConfigurer;
    }

    public synchronized String toXML() {
        return this.xStream.toXML((Object)this.pojoConfigurer);
    }

    public synchronized void toXML(OutputStream out) {
        this.xStream.toXML((Object)this.pojoConfigurer, out);
    }

    public synchronized void toXML(Writer out) {
        this.xStream.toXML((Object)this.pojoConfigurer, out);
    }

    protected static class AssertCheckConverter
    implements Converter {
        protected AssertCheckConverter() {
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(AssertCheck.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            ConstraintTarget[] appliesTo;
            int n;
            AssertCheck assertCheck = (AssertCheck)value;
            writer.addAttribute("lang", assertCheck.getLang());
            if (!"net.sf.oval.constraint.Assert.violated".equals(assertCheck.getMessage())) {
                writer.addAttribute("message", assertCheck.getMessage());
            }
            if (!"net.sf.oval.constraint.Assert".equals(assertCheck.getErrorCode())) {
                writer.addAttribute("errorCode", assertCheck.getErrorCode());
            }
            writer.addAttribute("severity", Integer.toString(assertCheck.getSeverity()));
            if (assertCheck.getWhen() != null) {
                writer.addAttribute("when", assertCheck.getWhen());
            }
            writer.startNode("expr");
            writer.setValue(assertCheck.getExpr());
            writer.endNode();
            String[] profiles = assertCheck.getProfiles();
            if (profiles != null && profiles.length > 0) {
                writer.startNode("profiles");
                String[] stringArray = profiles;
                n = profiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String profile = stringArray[n2];
                    writer.startNode("string");
                    writer.setValue(profile);
                    writer.endNode();
                    ++n2;
                }
                writer.endNode();
            }
            if ((appliesTo = assertCheck.getAppliesTo()) != null && appliesTo.length > 0) {
                writer.startNode("appliesTo");
                ConstraintTarget[] constraintTargetArray = appliesTo;
                int n3 = appliesTo.length;
                n = 0;
                while (n < n3) {
                    ConstraintTarget ctarget = constraintTargetArray[n];
                    writer.startNode("constraintTarget");
                    writer.setValue(ctarget.name());
                    writer.endNode();
                    ++n;
                }
                writer.endNode();
            }
        }

        public AssertCheck unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            AssertCheck assertCheck = new AssertCheck();
            assertCheck.setLang(reader.getAttribute("lang"));
            assertCheck.setMessage(reader.getAttribute("message"));
            assertCheck.setErrorCode(reader.getAttribute("errorCode"));
            if (reader.getAttribute("severity") != null) {
                assertCheck.setSeverity(Integer.parseInt(reader.getAttribute("severity")));
            }
            if (reader.getAttribute("expr") != null) {
                assertCheck.setExpr(reader.getAttribute("expr"));
            }
            assertCheck.setTarget(reader.getAttribute("target"));
            assertCheck.setWhen(reader.getAttribute("when"));
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                switch (reader.getNodeName()) {
                    case "appliesTo": {
                        ArrayList<ConstraintTarget> targets = new ArrayList<ConstraintTarget>(2);
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("constraintTarget".equals(reader.getNodeName())) {
                                targets.add(ConstraintTarget.valueOf(reader.getValue()));
                            }
                            reader.moveUp();
                        }
                        assertCheck.setAppliesTo(targets.toArray(new ConstraintTarget[targets.size()]));
                        break;
                    }
                    case "expr": {
                        assertCheck.setExpr(reader.getValue());
                        break;
                    }
                    case "profiles": {
                        ArrayList<String> profiles = new ArrayList<String>(4);
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("string".equals(reader.getNodeName())) {
                                profiles.add(reader.getValue());
                            }
                            reader.moveUp();
                        }
                        assertCheck.setProfiles(profiles.toArray(new String[profiles.size()]));
                    }
                }
                reader.moveUp();
            }
            XMLConfigurer.onCheckInitialized(assertCheck);
            return assertCheck;
        }
    }

    protected static class ListConverter
    extends CollectionConverter {
        protected ListConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return List.class.isAssignableFrom(type);
        }
    }

    protected static class PatternConverter
    implements Converter {
        protected PatternConverter() {
        }

        public boolean canConvert(Class type) {
            return type == Pattern.class;
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            Pattern pattern = (Pattern)value;
            writer.addAttribute("pattern", pattern.pattern());
            writer.addAttribute("flags", Integer.toString(pattern.flags()));
        }

        public Pattern unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String pattern = reader.getAttribute("pattern");
            String flags = reader.getAttribute("flags");
            if (flags == null || flags.trim().length() == 0) {
                return Pattern.compile(pattern);
            }
            return Pattern.compile(pattern, Integer.parseInt(flags));
        }
    }

    private static final class XStreamReflectionProvider
    extends PureJavaReflectionProvider {
        private XStreamReflectionProvider() {
        }

        public Object newInstance(Class type) {
            Object instance = super.newInstance(type);
            if (instance instanceof AbstractAnnotationCheck) {
                Class constraintAnnotation = null;
                ParameterizedType genericSuperclass = (ParameterizedType)type.getGenericSuperclass();
                Object[] objectArray = genericSuperclass.getActualTypeArguments();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type genericType = objectArray[n2];
                    Class genericClass = (Class)genericType;
                    if (genericClass.isAnnotation() && genericClass.isAnnotationPresent(Constraint.class)) {
                        constraintAnnotation = genericClass;
                        break;
                    }
                    ++n2;
                }
                if (constraintAnnotation != null) {
                    objectArray = constraintAnnotation.getMethods();
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object m = objectArray[n2];
                        Object defaultValue = ((Method)m).getDefaultValue();
                        if (defaultValue != null) {
                            ReflectionUtils.setViaSetter(instance, ((Method)m).getName(), defaultValue);
                        }
                        ++n2;
                    }
                }
            }
            return instance;
        }
    }
}

