/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation.impl;

import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.operation.impl.CaptureCollector;
import org.apache.storm.trident.operation.impl.ChainedResult;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class ChainedAggregatorImpl
implements Aggregator<ChainedResult> {
    Aggregator[] aggs;
    TridentTupleView.ProjectionFactory[] inputFactories;
    ComboList.Factory fact;
    Fields[] inputFields;

    public ChainedAggregatorImpl(Aggregator[] aggs, Fields[] inputFields, ComboList.Factory fact) {
        this.aggs = aggs;
        this.inputFields = inputFields;
        this.fact = fact;
        if (this.aggs.length != this.inputFields.length) {
            throw new IllegalArgumentException("Require input fields for each aggregator");
        }
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
        this.inputFactories = new TridentTupleView.ProjectionFactory[this.inputFields.length];
        for (int i = 0; i < this.inputFields.length; ++i) {
            this.inputFactories[i] = context.makeProjectionFactory(this.inputFields[i]);
            this.aggs[i].prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this.inputFactories[i]));
        }
    }

    @Override
    public ChainedResult init(Object batchId, TridentCollector collector) {
        ChainedResult initted = new ChainedResult(collector, this.aggs.length);
        for (int i = 0; i < this.aggs.length; ++i) {
            initted.objs[i] = this.aggs[i].init(batchId, initted.collectors[i]);
        }
        return initted;
    }

    @Override
    public void aggregate(ChainedResult val, TridentTuple tuple, TridentCollector collector) {
        val.setFollowThroughCollector(collector);
        for (int i = 0; i < this.aggs.length; ++i) {
            TridentTuple projected = this.inputFactories[i].create((TridentTupleView)tuple);
            this.aggs[i].aggregate(val.objs[i], projected, val.collectors[i]);
        }
    }

    @Override
    public void complete(ChainedResult val, TridentCollector collector) {
        val.setFollowThroughCollector(collector);
        for (int i = 0; i < this.aggs.length; ++i) {
            this.aggs[i].complete(val.objs[i], val.collectors[i]);
        }
        if (this.aggs.length > 1) {
            int[] indices = new int[val.collectors.length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = 0;
            }
            boolean keepGoing = true;
            while (keepGoing) {
                List[] combined = new List[this.aggs.length];
                for (int i = 0; i < this.aggs.length; ++i) {
                    CaptureCollector capturer = (CaptureCollector)val.collectors[i];
                    combined[i] = capturer.captured.get(indices[i]);
                }
                collector.emit(this.fact.create(combined));
                keepGoing = this.increment(val.collectors, indices, indices.length - 1);
            }
        }
    }

    private boolean increment(TridentCollector[] lengths, int[] indices, int j) {
        if (j == -1) {
            return false;
        }
        int n = j;
        indices[n] = indices[n] + 1;
        CaptureCollector capturer = (CaptureCollector)lengths[j];
        if (indices[j] >= capturer.captured.size()) {
            indices[j] = 0;
            return this.increment(lengths, indices, j - 1);
        }
        return true;
    }

    @Override
    public void cleanup() {
        for (Aggregator a : this.aggs) {
            a.cleanup();
        }
    }
}

