/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.util.Map;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.utils.ObjectReader;

public enum ThriftConnectionType {
    NIMBUS("nimbus.thrift.transport", "nimbus.thrift.port", "nimbus.queue.size", "nimbus.thrift.threads", "nimbus.thrift.max_buffer_size", "storm.thrift.socket.timeout.ms", WorkerTokenServiceType.NIMBUS, true),
    NIMBUS_TLS("nimbus.thrift.tls.transport", "nimbus.thrift.tls.port", "nimbus.queue.size", "nimbus.thrift.tls.threads", "nimbus.thrift.tls.max_buffer_size", "storm.thrift.tls.socket.timeout.ms", false, null, false, true, "nimbus.thrift.tls.client.auth.required", "nimbus.thrift.tls.server.keystore.path", "nimbus.thrift.tls.server.keystore.password", "nimbus.thrift.tls.server.truststore.path", "nimbus.thrift.tls.server.truststore.password", "nimbus.thrift.tls.client.keystore.path", "nimbus.thrift.tls.client.keystore.password", "nimbus.thrift.tls.client.truststore.path", "nimbus.thrift.tls.client.truststore.password", "nimbus.thrift.tls.client.key.path", "nimbus.thrift.tls.client.cert.path"),
    SUPERVISOR("supervisor.thrift.transport", "supervisor.thrift.port", "supervisor.queue.size", "supervisor.thrift.threads", "supervisor.thrift.max_buffer_size", "supervisor.thrift.socket.timeout.ms", WorkerTokenServiceType.SUPERVISOR, false),
    SUPERVISOR_TLS("supervisor.thrift.transport", "supervisor.thrift.port", "supervisor.queue.size", "supervisor.thrift.threads", "supervisor.thrift.max_buffer_size", "supervisor.thrift.socket.timeout.ms", false, null, false, true, "supervisor.thrift.tls.client.auth.required", "supervisor.thrift.tls.server.keystore.path", "supervisor.thrift.tls.server.keystore.password", "supervisor.thrift.tls.server.truststore.path", "supervisor.thrift.tls.server.truststore.password", "supervisor.thrift.tls.client.keystore.path", "supervisor.thrift.tls.client.keystore.password", "supervisor.thrift.tls.client.truststore.path", "supervisor.thrift.tls.client.truststore.password", "supervisor.thrift.tls.client.key.path", "supervisor.thrift.tls.client.cert.path"),
    DRPC("drpc.thrift.transport", "drpc.port", "drpc.queue.size", "drpc.worker.threads", "drpc.max_buffer_size", null, null, false),
    DRPC_INVOCATIONS("drpc.invocations.thrift.transport", "drpc.invocations.port", null, "drpc.invocations.threads", "drpc.max_buffer_size", null, WorkerTokenServiceType.DRPC, false),
    LOCAL_FAKE;

    private final String transConf;
    private final String portConf;
    private final String queueConf;
    private final String threadsConf;
    private final String buffConf;
    private final String socketTimeoutConf;
    private final boolean isFake;
    private final WorkerTokenServiceType wtType;
    private final boolean impersonationAllowed;
    private final boolean tlsEnabled;
    private final String clientAuthRequiredConf;
    private final String serverKeyStorePathConf;
    private final String serverKeyStorePasswordConf;
    private final String serverTrustStorePathConf;
    private final String serverTrustStorePasswordConf;
    private final String clientKeyStorePathConf;
    private final String clientKeyStorePasswordConf;
    private final String clientTrustStorePathConf;
    private final String clientTrustStorePasswordConf;
    private final String clientKeyPathConf;
    private final String clientCertPathConf;

    private ThriftConnectionType() {
        this(null, null, null, null, null, null, true, null, false);
    }

    private ThriftConnectionType(String transConf, String portConf, String queueConf, String threadsConf, String buffConf, String socketTimeoutConf, WorkerTokenServiceType wtType, boolean impersonationAllowed) {
        this(transConf, portConf, queueConf, threadsConf, buffConf, socketTimeoutConf, false, wtType, impersonationAllowed);
    }

    private ThriftConnectionType(String transConf, String portConf, String queueConf, String threadsConf, String buffConf, String socketTimeoutConf, boolean isFake, WorkerTokenServiceType wtType, boolean impersonationAllowed) {
        this(transConf, portConf, queueConf, threadsConf, buffConf, socketTimeoutConf, isFake, wtType, impersonationAllowed, false, null, null, null, null, null, null, null, null, null, null, null);
    }

    private ThriftConnectionType(String transConf, String portConf, String queueConf, String threadsConf, String buffConf, String socketTimeoutConf, boolean isFake, WorkerTokenServiceType wtType, boolean impersonationAllowed, boolean tlsEnabled, String clientAuthRequiredConf, String serverKeyStorePathConf, String serverKeyStorePasswordConf, String serverTrustStorePathConf, String serverTrustStorePasswordConf, String clientKeyStorePathConf, String clientKeyStorePasswordConf, String clientTrustStorePathConf, String clientTrustStorePasswordConf, String clientKeyPathConf, String clientCertPathConf) {
        this.transConf = transConf;
        this.portConf = portConf;
        this.queueConf = queueConf;
        this.threadsConf = threadsConf;
        this.buffConf = buffConf;
        this.socketTimeoutConf = socketTimeoutConf;
        this.isFake = isFake;
        this.wtType = wtType;
        this.impersonationAllowed = impersonationAllowed;
        this.tlsEnabled = tlsEnabled;
        this.clientAuthRequiredConf = clientAuthRequiredConf;
        this.serverKeyStorePathConf = serverKeyStorePathConf;
        this.serverKeyStorePasswordConf = serverKeyStorePasswordConf;
        this.serverTrustStorePathConf = serverTrustStorePathConf;
        this.serverTrustStorePasswordConf = serverTrustStorePasswordConf;
        this.clientKeyStorePathConf = clientKeyStorePathConf;
        this.clientKeyStorePasswordConf = clientKeyStorePasswordConf;
        this.clientTrustStorePathConf = clientTrustStorePathConf;
        this.clientTrustStorePasswordConf = clientTrustStorePasswordConf;
        this.clientKeyPathConf = clientKeyPathConf;
        this.clientCertPathConf = clientCertPathConf;
    }

    public boolean isFake() {
        return this.isFake;
    }

    public String getTransportPlugin(Map<String, Object> conf) {
        String ret = (String)conf.get(this.transConf);
        if (ret == null) {
            ret = (String)conf.get("storm.thrift.transport");
        }
        return ret;
    }

    public int getPort(Map<String, Object> conf) {
        if (this.isFake) {
            return -1;
        }
        return ObjectReader.getInt(conf.get(this.portConf));
    }

    public Integer getQueueSize(Map<String, Object> conf) {
        if (this.queueConf == null) {
            return null;
        }
        return (Integer)conf.get(this.queueConf);
    }

    public int getNumThreads(Map<String, Object> conf) {
        if (this.isFake) {
            return 1;
        }
        return ObjectReader.getInt(conf.get(this.threadsConf));
    }

    public int getMaxBufferSize(Map<String, Object> conf) {
        if (this.isFake) {
            return 1;
        }
        return ObjectReader.getInt(conf.get(this.buffConf));
    }

    public Integer getSocketTimeOut(Map<String, Object> conf) {
        if (this.socketTimeoutConf == null) {
            return null;
        }
        return ObjectReader.getInt(conf.get(this.socketTimeoutConf));
    }

    public WorkerTokenServiceType getWtType() {
        return this.wtType;
    }

    public boolean isImpersonationAllowed() {
        return this.impersonationAllowed;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public boolean isClientAuthRequired(Map<String, Object> conf) {
        boolean clientAuthRequired = false;
        if (this.tlsEnabled) {
            clientAuthRequired = ObjectReader.getBoolean(conf.get(this.clientAuthRequiredConf), false);
        }
        return clientAuthRequired;
    }

    public String getServerKeyStorePath(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.serverKeyStorePathConf), null);
    }

    public String getServerKeyStorePassword(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.serverKeyStorePasswordConf), null);
    }

    public String getServerTrustStorePath(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.serverTrustStorePathConf), null);
    }

    public String getServerTrustStorePassword(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.serverTrustStorePasswordConf), null);
    }

    public String getClientKeyStorePath(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.clientKeyStorePathConf), null);
    }

    public String getClientKeyStorePassword(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.clientKeyStorePasswordConf), null);
    }

    public String getClientTrustStorePath(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.clientTrustStorePathConf), null);
    }

    public String getClientTrustStorePassword(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.clientTrustStorePasswordConf), null);
    }

    public String getClientKeyPath(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.clientKeyPathConf), null);
    }

    public String getClientCertPath(Map<String, Object> conf) {
        return ObjectReader.getString(conf.get(this.clientCertPathConf), null);
    }
}

