/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.handler.codec.http;

import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelHandler;
import org.apache.storm.shade.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.storm.shade.io.netty.handler.codec.compression.Brotli;
import org.apache.storm.shade.io.netty.handler.codec.compression.BrotliDecoder;
import org.apache.storm.shade.io.netty.handler.codec.compression.SnappyFrameDecoder;
import org.apache.storm.shade.io.netty.handler.codec.compression.ZlibCodecFactory;
import org.apache.storm.shade.io.netty.handler.codec.compression.ZlibWrapper;
import org.apache.storm.shade.io.netty.handler.codec.compression.Zstd;
import org.apache.storm.shade.io.netty.handler.codec.compression.ZstdDecoder;
import org.apache.storm.shade.io.netty.handler.codec.http.HttpContentDecoder;
import org.apache.storm.shade.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.storm.shade.io.netty.util.internal.ObjectUtil;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;
    private final int maxAllocation;

    @Deprecated
    public HttpContentDecompressor() {
        this(false, 0);
    }

    public HttpContentDecompressor(int maxAllocation) {
        this(false, maxAllocation);
    }

    @Deprecated
    public HttpContentDecompressor(boolean strict) {
        this(strict, 0);
    }

    public HttpContentDecompressor(boolean strict, int maxAllocation) {
        this.strict = strict;
        this.maxAllocation = ObjectUtil.checkPositiveOrZero(maxAllocation, "maxAllocation");
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        Channel channel = this.ctx.channel();
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP, this.maxAllocation)).build();
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)ZlibCodecFactory.newZlibDecoder(wrapper, this.maxAllocation)).build();
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)new BrotliDecoder()).build();
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)new SnappyFrameDecoder()).build();
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase(contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)new ZstdDecoder()).build();
        }
        return null;
    }
}

