/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.util.Map;
import org.apache.storm.shade.io.netty.channel.ChannelOption;
import org.apache.storm.shade.io.netty.channel.RecvByteBufAllocator;
import org.apache.storm.shade.io.netty.channel.uring.AbstractIoUringChannel;
import org.apache.storm.shade.io.netty.channel.uring.IoUringChannelConfig;
import org.apache.storm.shade.io.netty.channel.uring.IoUringChannelOption;
import org.apache.storm.shade.io.netty.util.internal.ObjectUtil;

abstract class IoUringStreamChannelConfig
extends IoUringChannelConfig {
    private volatile short bufferGroupId = (short)-1;

    IoUringStreamChannelConfig(AbstractIoUringChannel channel) {
        super(channel);
    }

    IoUringStreamChannelConfig(AbstractIoUringChannel channel, RecvByteBufAllocator allocator) {
        super(channel, allocator);
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) {
        if (option == IoUringChannelOption.IO_URING_BUFFER_GROUP_ID) {
            return (T)Short.valueOf(this.getBufferGroupId());
        }
        return super.getOption(option);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value) {
        if (option == IoUringChannelOption.IO_URING_BUFFER_GROUP_ID) {
            this.setBufferGroupId((Short)value);
            return true;
        }
        return super.setOption(option, value);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), IoUringChannelOption.IO_URING_BUFFER_GROUP_ID);
    }

    short getBufferGroupId() {
        return this.bufferGroupId;
    }

    IoUringStreamChannelConfig setBufferGroupId(short bufferGroupId) {
        this.bufferGroupId = (short)ObjectUtil.checkPositiveOrZero(bufferGroupId, "bufferGroupId");
        return this;
    }
}

