/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Map;
import org.apache.storm.generated.Supervisor;
import org.apache.storm.security.auth.ThriftClient;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.SupervisorIfaceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorClient
extends ThriftClient
implements SupervisorIfaceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorClient.class);
    private Supervisor.Client client;

    private SupervisorClient(Map conf, ThriftConnectionType type, String host, Integer port, String asUser) throws TTransportException {
        super(conf, type, host, port, null, asUser);
        this.client = new Supervisor.Client(this.protocol);
    }

    @Deprecated
    public SupervisorClient(Map conf, String host, int port) throws TTransportException {
        this(conf, host, port, null, null);
    }

    @Deprecated
    public SupervisorClient(Map conf, String host, int port, Integer timeout) throws TTransportException {
        super(conf, ThriftConnectionType.SUPERVISOR, host, port, timeout, null);
        this.client = new Supervisor.Client(this.protocol);
    }

    @Deprecated
    public SupervisorClient(Map conf, String host, Integer port, Integer timeout, String asUser) throws TTransportException {
        super(conf, ThriftConnectionType.SUPERVISOR, host, port, timeout, asUser);
        this.client = new Supervisor.Client(this.protocol);
    }

    @Deprecated
    public SupervisorClient(Map conf, String host) throws TTransportException {
        super(conf, ThriftConnectionType.SUPERVISOR, host, null, null, null);
        this.client = new Supervisor.Client(this.protocol);
    }

    @Deprecated
    public static SupervisorClient getConfiguredClient(Map conf, String host) {
        int port = Integer.parseInt(conf.get("supervisor.thrift.port").toString());
        return SupervisorClient.getConfiguredClientAs(conf, host, port, null);
    }

    @Deprecated
    public static SupervisorClient getConfiguredClient(Map conf, String host, int port) {
        return SupervisorClient.getConfiguredClientAs(conf, host, port, null);
    }

    @Deprecated
    public static SupervisorClient getConfiguredClientAs(Map conf, String host, int port, String asUser) {
        if (conf.containsKey("storm.doAsUser")) {
            if (asUser != null && !asUser.isEmpty()) {
                LOG.warn("You have specified a doAsUser as param {} and a doAsParam as config, config will take precedence.", (Object)asUser, conf.get("storm.doAsUser"));
            }
            asUser = (String)conf.get("storm.doAsUser");
        }
        try {
            return new SupervisorClient(conf, host, port, null, asUser);
        }
        catch (TTransportException e) {
            throw new RuntimeException("Failed to create a supervisor client for host " + host);
        }
    }

    @Override
    public Supervisor.Client getIface() {
        return this.client;
    }

    public static class Builder {
        private Map conf;
        private String hostname;
        private Integer port;
        private String asUser;

        private Builder(Map<String, Object> conf) {
            this.conf = conf;
        }

        public static Builder withConf(Map<String, Object> conf) {
            return new Builder(conf);
        }

        public Builder withHostName(String hostName) {
            this.hostname = hostName;
            return this;
        }

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public SupervisorClient build() throws TTransportException {
            boolean useTls = ObjectReader.getBoolean(this.conf.get("supervisor.thrift.client.use.tls"), false);
            ThriftConnectionType type = useTls ? ThriftConnectionType.SUPERVISOR_TLS : ThriftConnectionType.SUPERVISOR;
            return new SupervisorClient(this.conf, type, this.hostname, this.port, this.asUser);
        }

        public SupervisorClient createSupervisorClient() {
            try {
                if (this.conf.containsKey("storm.doAsUser")) {
                    if (this.asUser != null && !this.asUser.isEmpty()) {
                        LOG.warn("You have specified a doAsUser as param {} and a doAsParam as config, config will take precedence.", (Object)this.asUser, this.conf.get("storm.doAsUser"));
                    }
                    this.asUser = (String)this.conf.get("storm.doAsUser");
                }
                return this.build();
            }
            catch (TTransportException e) {
                throw new RuntimeException("Failed to create a supervisor client for host " + this.hostname);
            }
        }
    }
}

