/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.shade.org.apache.commons.codec.binary.Base64;

class SaslUtils {
    public static final String KERBEROS = "GSSAPI";
    public static final String AUTH_DIGEST_MD5 = "DIGEST-MD5";
    public static final String DEFAULT_REALM = "default";

    SaslUtils() {
    }

    static Map<String, String> getSaslProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.security.sasl.policy.noplaintext", "true");
        return props;
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64((byte[])password), StandardCharsets.UTF_8).toCharArray();
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64((byte[])identifier), StandardCharsets.UTF_8);
    }

    static String getSecretKey(Map<String, Object> conf) {
        return conf == null || conf.isEmpty() ? null : (String)conf.get("storm.zookeeper.topology.auth.payload");
    }
}

