/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.drpc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.Constants;
import org.apache.storm.ILocalDRPC;
import org.apache.storm.coordination.BatchBoltExecutor;
import org.apache.storm.coordination.CoordinatedBolt;
import org.apache.storm.coordination.IBatchBolt;
import org.apache.storm.drpc.DRPCSpout;
import org.apache.storm.drpc.JoinResult;
import org.apache.storm.drpc.LinearDRPCInputDeclarer;
import org.apache.storm.drpc.PrepareRequest;
import org.apache.storm.drpc.ReturnResults;
import org.apache.storm.generated.SharedMemory;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.grouping.PartialKeyGrouping;
import org.apache.storm.topology.BaseConfigurationDeclarer;
import org.apache.storm.topology.BasicBoltExecutor;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.InputDeclarer;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;

public class LinearDRPCTopologyBuilder {
    String function;
    List<Component> components = new ArrayList<Component>();

    public LinearDRPCTopologyBuilder(String function) {
        this.function = function;
    }

    private static String boltId(int index) {
        return "bolt" + index;
    }

    public LinearDRPCInputDeclarer addBolt(IBatchBolt bolt, Number parallelism) {
        return this.addBolt(new BatchBoltExecutor(bolt), parallelism);
    }

    public LinearDRPCInputDeclarer addBolt(IBatchBolt bolt) {
        return this.addBolt(bolt, (Number)1);
    }

    @Deprecated
    public LinearDRPCInputDeclarer addBolt(IRichBolt bolt, Number parallelism) {
        if (parallelism == null) {
            parallelism = 1;
        }
        Component component = new Component(bolt, parallelism.intValue());
        this.components.add(component);
        return new InputDeclarerImpl(component);
    }

    @Deprecated
    public LinearDRPCInputDeclarer addBolt(IRichBolt bolt) {
        return this.addBolt(bolt, null);
    }

    public LinearDRPCInputDeclarer addBolt(IBasicBolt bolt, Number parallelism) {
        return this.addBolt(new BasicBoltExecutor(bolt), parallelism);
    }

    public LinearDRPCInputDeclarer addBolt(IBasicBolt bolt) {
        return this.addBolt(bolt, null);
    }

    public StormTopology createLocalTopology(ILocalDRPC drpc) {
        return this.createTopology(new DRPCSpout(this.function, drpc));
    }

    public StormTopology createRemoteTopology() {
        return this.createTopology(new DRPCSpout(this.function));
    }

    private StormTopology createTopology(DRPCSpout spout) {
        int i;
        String SPOUT_ID = "spout";
        String PREPARE_ID = "prepare-request";
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout("spout", spout);
        builder.setBolt("prepare-request", new PrepareRequest()).noneGrouping("spout");
        for (i = 0; i < this.components.size(); ++i) {
            Component component = this.components.get(i);
            HashMap<String, CoordinatedBolt.SourceArgs> source = new HashMap<String, CoordinatedBolt.SourceArgs>();
            if (i == 1) {
                source.put(LinearDRPCTopologyBuilder.boltId(i - 1), CoordinatedBolt.SourceArgs.single());
            } else if (i >= 2) {
                source.put(LinearDRPCTopologyBuilder.boltId(i - 1), CoordinatedBolt.SourceArgs.all());
            }
            CoordinatedBolt.IdStreamSpec idSpec = null;
            if (i == this.components.size() - 1 && component.bolt instanceof CoordinatedBolt.FinishedCallback) {
                idSpec = CoordinatedBolt.IdStreamSpec.makeDetectSpec("prepare-request", "id");
            }
            BoltDeclarer declarer = builder.setBolt(LinearDRPCTopologyBuilder.boltId(i), new CoordinatedBolt(component.bolt, source, idSpec), (Number)component.parallelism);
            for (SharedMemory request : component.sharedMemory) {
                declarer.addSharedMemory(request);
            }
            if (!component.componentConf.isEmpty()) {
                declarer.addConfigurations(component.componentConf);
            }
            if (idSpec != null) {
                declarer.fieldsGrouping(idSpec.getGlobalStreamId().get_componentId(), "id", new Fields("request"));
            }
            if (i == 0 && component.declarations.isEmpty()) {
                declarer.noneGrouping("prepare-request", "default");
            } else {
                String prevId = i == 0 ? "prepare-request" : LinearDRPCTopologyBuilder.boltId(i - 1);
                for (InputDeclaration declaration : component.declarations) {
                    declaration.declare(prevId, declarer);
                }
            }
            if (i <= 0) continue;
            declarer.directGrouping(LinearDRPCTopologyBuilder.boltId(i - 1), Constants.COORDINATED_STREAM_ID);
        }
        IRichBolt lastBolt = this.components.get((int)(this.components.size() - 1)).bolt;
        OutputFieldsGetter getter = new OutputFieldsGetter();
        lastBolt.declareOutputFields(getter);
        Map<String, StreamInfo> streams = getter.getFieldsDeclaration();
        if (streams.size() != 1) {
            throw new RuntimeException("Must declare exactly one stream from last bolt in LinearDRPCTopology");
        }
        String outputStream = streams.keySet().iterator().next();
        List<String> fields = streams.get(outputStream).get_output_fields();
        if (fields.size() != 2) {
            throw new RuntimeException("Output stream of last component in LinearDRPCTopology must contain exactly two fields. The first should be the request id, and the second should be the result.");
        }
        ((BoltDeclarer)builder.setBolt(LinearDRPCTopologyBuilder.boltId(i), new JoinResult("prepare-request")).fieldsGrouping(LinearDRPCTopologyBuilder.boltId(i - 1), outputStream, new Fields(fields.get(0)))).fieldsGrouping("prepare-request", "ret", new Fields("request"));
        builder.setBolt(LinearDRPCTopologyBuilder.boltId(++i), new ReturnResults()).noneGrouping(LinearDRPCTopologyBuilder.boltId(i - 1));
        return builder.createTopology();
    }

    private static class Component {
        public final IRichBolt bolt;
        public final int parallelism;
        public final Map<String, Object> componentConf = new HashMap<String, Object>();
        public final List<InputDeclaration> declarations = new ArrayList<InputDeclaration>();
        public final Set<SharedMemory> sharedMemory = new HashSet<SharedMemory>();

        Component(IRichBolt bolt, int parallelism) {
            this.bolt = bolt;
            this.parallelism = parallelism;
        }
    }

    private static class InputDeclarerImpl
    extends BaseConfigurationDeclarer<LinearDRPCInputDeclarer>
    implements LinearDRPCInputDeclarer {
        Component component;

        InputDeclarerImpl(Component component) {
            this.component = component;
        }

        @Override
        public LinearDRPCInputDeclarer fieldsGrouping(final Fields fields) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.fieldsGrouping(prevComponent, fields);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer fieldsGrouping(final String streamId, final Fields fields) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.fieldsGrouping(prevComponent, streamId, fields);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer globalGrouping() {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.globalGrouping(prevComponent);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer globalGrouping(final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.globalGrouping(prevComponent, streamId);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer shuffleGrouping() {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.shuffleGrouping(prevComponent);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer shuffleGrouping(final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.shuffleGrouping(prevComponent, streamId);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer localOrShuffleGrouping() {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(prevComponent);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer localOrShuffleGrouping(final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(prevComponent, streamId);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer noneGrouping() {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.noneGrouping(prevComponent);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer noneGrouping(final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.noneGrouping(prevComponent, streamId);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer allGrouping() {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.allGrouping(prevComponent);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer allGrouping(final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.allGrouping(prevComponent, streamId);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer directGrouping() {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.directGrouping(prevComponent);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer directGrouping(final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.directGrouping(prevComponent, streamId);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer partialKeyGrouping(Fields fields) {
            return this.customGrouping(new PartialKeyGrouping(fields));
        }

        @Override
        public LinearDRPCInputDeclarer partialKeyGrouping(String streamId, Fields fields) {
            return this.customGrouping(streamId, new PartialKeyGrouping(fields));
        }

        @Override
        public LinearDRPCInputDeclarer customGrouping(final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.customGrouping(prevComponent, grouping);
                }
            });
            return this;
        }

        @Override
        public LinearDRPCInputDeclarer customGrouping(final String streamId, final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(String prevComponent, InputDeclarer declarer) {
                    declarer.customGrouping(prevComponent, streamId, grouping);
                }
            });
            return this;
        }

        private void addDeclaration(InputDeclaration declaration) {
            this.component.declarations.add(declaration);
        }

        @Override
        public LinearDRPCInputDeclarer addConfigurations(Map<String, Object> conf) {
            if (conf != null) {
                this.component.componentConf.putAll(conf);
            }
            return this;
        }

        @Override
        public Map<String, Object> getComponentConfiguration() {
            return this.component.componentConf;
        }

        @Override
        public LinearDRPCInputDeclarer addSharedMemory(SharedMemory request) {
            this.component.sharedMemory.add(request);
            return this;
        }
    }

    private static interface InputDeclaration {
        public void declare(String var1, InputDeclarer var2);
    }
}

