/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetTimeStampTime extends BACnetTimeStamp implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetContextTagTime timeValue;

  public BACnetTimeStampTime(BACnetTagHeader peekedTagHeader, BACnetContextTagTime timeValue) {
    super(peekedTagHeader);
    this.timeValue = timeValue;
  }

  public BACnetContextTagTime getTimeValue() {
    return timeValue;
  }

  @Override
  protected void serializeBACnetTimeStampChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetTimeStampTime");

    // Simple Field (timeValue)
    writeSimpleField("timeValue", timeValue, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetTimeStampTime");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetTimeStampTime _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (timeValue)
    lengthInBits += timeValue.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetTimeStampBuilder staticParseBACnetTimeStampBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetTimeStampTime");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagTime timeValue =
        readSimpleField(
            "timeValue",
            readComplex(
                () ->
                    (BACnetContextTagTime)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (0), (BACnetDataType) (BACnetDataType.TIME)),
                readBuffer));

    readBuffer.closeContext("BACnetTimeStampTime");
    // Create the instance
    return new BACnetTimeStampTimeBuilderImpl(timeValue);
  }

  public static class BACnetTimeStampTimeBuilderImpl
      implements BACnetTimeStamp.BACnetTimeStampBuilder {
    private final BACnetContextTagTime timeValue;

    public BACnetTimeStampTimeBuilderImpl(BACnetContextTagTime timeValue) {
      this.timeValue = timeValue;
    }

    public BACnetTimeStampTime build(BACnetTagHeader peekedTagHeader) {
      BACnetTimeStampTime bACnetTimeStampTime = new BACnetTimeStampTime(peekedTagHeader, timeValue);
      return bACnetTimeStampTime;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetTimeStampTime)) {
      return false;
    }
    BACnetTimeStampTime that = (BACnetTimeStampTime) o;
    return (getTimeValue() == that.getTimeValue()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTimeValue());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
