/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.bval.util.Comparators;
import org.apache.bval.util.Exceptions;

public abstract class NodeImpl
implements Path.Node,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Comparator<Path.Node> NODE_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(Path.Node::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(NodeImpl::compareIterability).thenComparing(NodeImpl::compareSpecificNodeInfo));
    private static final Comparator<Path.Node> NODE_EQUALITY_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(Path.Node::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing((o1, o2) -> NodeImpl.compareIterability(o1, o2, false)).thenComparing(NodeImpl::compareSpecificNodeInfo));
    private static final Comparator<Class<?>> CLASS_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(Class::isPrimitive).reversed().thenComparing(Class::getName));
    private static final Comparator<Object> KEY_COMPARATOR = Comparator.nullsFirst(((Comparator)(quid, quo) -> {
        if (quid instanceof Comparable && quo instanceof Comparable) {
            try {
                return Comparator.naturalOrder().compare((Comparable)quid, (Comparable)quo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (quid instanceof Class && quo instanceof Class) {
            return CLASS_COMPARATOR.compare((Class)quid, (Class)quo);
        }
        return 0;
    }).thenComparing(Objects::toString));
    private static final char INDEX_OPEN = '[';
    private static final char INDEX_CLOSE = ']';
    private String name;
    private boolean inIterable;
    private Integer index;
    private int parameterIndex;
    private Object key;
    private List<Class<?>> parameterTypes;
    private Class<?> containerType;
    private Integer typeArgumentIndex;

    private static <T extends Path.Node> Optional<T> optional(Class<T> type, Object o) {
        return Optional.ofNullable(o).filter(type::isInstance).map(type::cast);
    }

    public static StringBuilder appendNode(Path.Node node, StringBuilder to) {
        if (node.isInIterable()) {
            to.append('[');
            if (node.getIndex() != null) {
                to.append(node.getIndex());
            } else if (node.getKey() != null) {
                to.append(node.getKey());
            }
            to.append(']');
        }
        if (node.getName() != null) {
            if (to.length() > 0) {
                to.append(".");
            }
            to.append(node.getName());
        }
        return to;
    }

    public static NodeImpl atIndex(Integer index) {
        PropertyNodeImpl result = new PropertyNodeImpl((String)null);
        result.setIndex(index);
        return result;
    }

    public static NodeImpl atKey(Object key) {
        PropertyNodeImpl result = new PropertyNodeImpl((String)null);
        result.setKey(key);
        return result;
    }

    private static int compareIterability(Path.Node quid, Path.Node quo) {
        boolean strict = true;
        return NodeImpl.compareIterability(quid, quo, true);
    }

    private static int compareIterability(Path.Node quid, Path.Node quo, boolean strict) {
        if (quid.isInIterable()) {
            if (quo.isInIterable()) {
                if (quid.getKey() != null) {
                    return Comparator.comparing(Path.Node::getKey, KEY_COMPARATOR).compare(quid, quo);
                }
                if (quo.getKey() != null) {
                    return -1;
                }
                if (quid.getIndex() == null) {
                    if (strict) {
                        return -1;
                    }
                    return quo.getIndex() == null ? 0 : -1;
                }
                return quo.getIndex() == null ? 1 : quid.getIndex().compareTo(quo.getIndex());
            }
            return 1;
        }
        return quo.isInIterable() ? -1 : 0;
    }

    private static int compareSpecificNodeInfo(Path.Node quid, Path.Node quo) {
        Comparator<Object> cmp;
        ElementKind kind = quid.getKind();
        int k = kind.compareTo(quo.getKind());
        if (k != 0) {
            return k;
        }
        switch (kind) {
            case BEAN: {
                cmp = Comparator.comparing(NodeImpl.to(Path.BeanNode.class), Comparator.comparing(Path.BeanNode::getContainerClass, CLASS_COMPARATOR).thenComparing(Path.BeanNode::getTypeArgumentIndex, Comparator.nullsFirst(Comparator.naturalOrder())));
                break;
            }
            case PROPERTY: {
                cmp = Comparator.comparing(NodeImpl.to(Path.PropertyNode.class), Comparator.comparing(Path.PropertyNode::getContainerClass, CLASS_COMPARATOR).thenComparing(Path.PropertyNode::getTypeArgumentIndex, Comparator.nullsFirst(Comparator.naturalOrder())));
                break;
            }
            case CONTAINER_ELEMENT: {
                cmp = Comparator.comparing(NodeImpl.to(Path.ContainerElementNode.class), Comparator.comparing(Path.ContainerElementNode::getContainerClass, CLASS_COMPARATOR).thenComparing(Path.ContainerElementNode::getTypeArgumentIndex, Comparator.nullsFirst(Comparator.naturalOrder())));
                break;
            }
            case CONSTRUCTOR: {
                cmp = Comparator.comparing(NodeImpl.to(Path.ConstructorNode.class).andThen(Path.ConstructorNode::getParameterTypes), Comparators.comparingIterables(CLASS_COMPARATOR));
                break;
            }
            case METHOD: {
                cmp = Comparator.comparing(NodeImpl.to(Path.MethodNode.class).andThen(Path.MethodNode::getParameterTypes), Comparators.comparingIterables(CLASS_COMPARATOR));
                break;
            }
            case PARAMETER: {
                cmp = Comparator.comparing(NodeImpl.to(Path.ParameterNode.class).andThen(Path.ParameterNode::getParameterIndex));
                break;
            }
            default: {
                return 0;
            }
        }
        return cmp.compare(quid, quo);
    }

    private static <T> Function<Object, T> to(Class<T> type) {
        return type::cast;
    }

    private NodeImpl(String name) {
        this.name = name;
    }

    NodeImpl(Path.Node node) {
        this(node.getName());
        this.inIterable = node.isInIterable();
        this.index = node.getIndex();
        this.key = node.getKey();
        if (node instanceof NodeImpl) {
            NodeImpl n = (NodeImpl)node;
            this.parameterIndex = n.parameterIndex;
            this.parameterTypes = n.parameterTypes;
            this.containerType = n.containerType;
            this.typeArgumentIndex = n.typeArgumentIndex;
        }
    }

    <T extends Path.Node> NodeImpl(Path.Node node, Class<T> nodeType, Consumer<T> handler) {
        this(node);
        Optional.of(node).filter(nodeType::isInstance).map(nodeType::cast).ifPresent(handler);
    }

    private NodeImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isInIterable() {
        return this.inIterable;
    }

    public void setInIterable(boolean inIterable) {
        this.inIterable = inIterable;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.inIterable = true;
        this.index = index;
        this.key = null;
    }

    public void setParameterIndex(Integer parameterIndex) {
        this.parameterIndex = parameterIndex;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.inIterable = true;
        this.key = key;
        this.index = null;
    }

    @Override
    public <T extends Path.Node> T as(Class<T> nodeType) {
        Exceptions.raiseUnless(nodeType.isInstance(this), ClassCastException::new, "Type %s not supported by %s", f -> f.args(nodeType, this.getClass()));
        return (T)((Path.Node)nodeType.cast(this));
    }

    @Override
    public String toString() {
        return NodeImpl.appendNode(this, new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return NODE_EQUALITY_COMPARATOR.compare(this, (NodeImpl)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.inIterable, this.index, this.key, this.getKind()});
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public List<Class<?>> getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(List<Class<?>> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Class<?> getContainerClass() {
        return this.containerType;
    }

    public Integer getTypeArgumentIndex() {
        return this.typeArgumentIndex;
    }

    public NodeImpl inIterable() {
        this.setInIterable(true);
        return this;
    }

    public NodeImpl inContainer(Class<?> containerType, Integer typeArgumentIndex) {
        this.containerType = containerType;
        this.typeArgumentIndex = typeArgumentIndex;
        return this;
    }

    public static class ContainerElementNodeImpl
    extends NodeImpl
    implements Path.ContainerElementNode {
        public ContainerElementNodeImpl(String name) {
            super(name);
        }

        public ContainerElementNodeImpl(String name, Class<?> containerType, Integer typeArgumentIndex) {
            this(name);
            this.inContainer(containerType, typeArgumentIndex);
        }

        public ContainerElementNodeImpl(Path.Node cast) {
            super(cast);
            NodeImpl.optional(Path.ContainerElementNode.class, cast).ifPresent(n -> this.inContainer(n.getContainerClass(), n.getTypeArgumentIndex()));
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONTAINER_ELEMENT;
        }
    }

    public static class BeanNodeImpl
    extends NodeImpl
    implements Path.BeanNode {
        public BeanNodeImpl() {
        }

        public BeanNodeImpl(Path.Node cast) {
            super(cast);
            NodeImpl.optional(Path.BeanNode.class, cast).ifPresent(n -> this.inContainer(n.getContainerClass(), n.getTypeArgumentIndex()));
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.BEAN;
        }
    }

    public static class PropertyNodeImpl
    extends NodeImpl
    implements Path.PropertyNode {
        public PropertyNodeImpl(String name) {
            super(name);
        }

        public PropertyNodeImpl(Path.Node cast) {
            super(cast);
            NodeImpl.optional(Path.PropertyNode.class, cast).ifPresent(n -> this.inContainer(n.getContainerClass(), n.getTypeArgumentIndex()));
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PROPERTY;
        }
    }

    public static class ReturnValueNodeImpl
    extends NodeImpl
    implements Path.ReturnValueNode {
        public ReturnValueNodeImpl(Path.Node cast) {
            super(cast);
        }

        public ReturnValueNodeImpl() {
            super("<return value>");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RETURN_VALUE;
        }
    }

    public static class MethodNodeImpl
    extends NodeImpl
    implements Path.MethodNode {
        public MethodNodeImpl(Path.Node cast) {
            super(cast);
            NodeImpl.optional(Path.MethodNode.class, cast).ifPresent(n -> this.setParameterTypes(n.getParameterTypes()));
        }

        public MethodNodeImpl(String name, List<Class<?>> classes) {
            super(name);
            this.setParameterTypes(classes);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.METHOD;
        }
    }

    public static class CrossParameterNodeImpl
    extends NodeImpl
    implements Path.CrossParameterNode {
        public CrossParameterNodeImpl() {
            super("<cross-parameter>");
        }

        public CrossParameterNodeImpl(Path.Node cast) {
            super(cast);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CROSS_PARAMETER;
        }
    }

    public static class ConstructorNodeImpl
    extends NodeImpl
    implements Path.ConstructorNode {
        public ConstructorNodeImpl(Path.Node cast) {
            super(cast);
            NodeImpl.optional(Path.ConstructorNode.class, cast).ifPresent(n -> this.setParameterTypes(n.getParameterTypes()));
        }

        public ConstructorNodeImpl(String simpleName, List<Class<?>> paramTypes) {
            super(simpleName);
            this.setParameterTypes(paramTypes);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }
    }

    public static class ParameterNodeImpl
    extends NodeImpl
    implements Path.ParameterNode {
        public ParameterNodeImpl(Path.Node cast) {
            super(cast);
            NodeImpl.optional(Path.ParameterNode.class, cast).ifPresent(n -> this.setParameterIndex(n.getParameterIndex()));
        }

        public ParameterNodeImpl(String name, int idx) {
            super(name);
            this.setParameterIndex(idx);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }
    }
}

