/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.GeneralException;

public abstract class AbstractManagedRuntime
implements ManagedRuntime {
    private static Localizer _loc = Localizer.forPackage(AbstractManagedRuntime.class);

    @Override
    public Object getTransactionKey() throws Exception, SystemException {
        return this.getTransactionManager().getTransaction();
    }

    @Override
    public void doNonTransactionalWork(Runnable runnable) throws NotSupportedException {
        TransactionManager tm = null;
        Transaction transaction = null;
        try {
            tm = this.getTransactionManager();
        }
        catch (Exception e) {
            NotSupportedException nse = new NotSupportedException(e.getMessage());
            nse.initCause(e);
            throw nse;
        }
        try {
            transaction = tm.suspend();
        }
        catch (Exception e) {
            NotSupportedException nse = new NotSupportedException(_loc.get("exc-suspend-tran", e.getClass()).getMessage());
            nse.initCause(e);
            throw nse;
        }
        runnable.run();
        try {
            tm.resume(transaction);
        }
        catch (Exception e) {
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException se2) {
                throw new GeneralException(se2);
            }
            NotSupportedException nse = new NotSupportedException(_loc.get("exc-resume-tran", e.getClass()).getMessage());
            nse.initCause(e);
            throw nse;
        }
    }
}

