/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Numbers;

public class IntEntry
extends Entry
implements ConstantEntry {
    private int _value = -1;

    public IntEntry() {
    }

    public IntEntry(int value) {
        this._value = value;
    }

    @Override
    public int getType() {
        return 3;
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int value) {
        Object key = this.beforeModify();
        this._value = value;
        this.afterModify(key);
    }

    @Override
    public Object getConstant() {
        return Numbers.valueOf(this.getValue());
    }

    @Override
    public void setConstant(Object value) {
        this.setValue(((Number)value).intValue());
    }

    @Override
    protected void readData(DataInput in) throws IOException {
        this._value = in.readInt();
    }

    @Override
    protected void writeData(DataOutput out) throws IOException {
        out.writeInt(this._value);
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterIntEntry(this);
        visit.exitIntEntry(this);
    }
}

