/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.meta.AbstractManagedType;

public class Members {

    public static class MapAttributeImpl<X, K, V>
    extends PluralAttributeImpl<X, Map<K, V>, V>
    implements MapAttribute<X, K, V> {
        public MapAttributeImpl(AbstractManagedType<X> owner, FieldMetaData fmd) {
            super(owner, fmd);
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.MAP;
        }

        @Override
        public Class<K> getKeyJavaType() {
            return this.fmd.getKey().getDeclaredType();
        }

        @Override
        public Type<K> getKeyType() {
            return this.owner.model.getType(this.getKeyJavaType());
        }

        @Override
        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            return Attribute.PersistentAttributeType.MANY_TO_MANY;
        }
    }

    public static class KeyAttributeImpl<X, K>
    extends SetAttributeImpl<X, K> {
        public KeyAttributeImpl(AbstractManagedType<X> owner, FieldMetaData fmd) {
            super(owner, fmd);
        }

        @Override
        public Class<K> getBindableJavaType() {
            return this.fmd.getKey().getDeclaredType();
        }
    }

    public static class SetAttributeImpl<X, E>
    extends PluralAttributeImpl<X, Set<E>, E>
    implements SetAttribute<X, E> {
        public SetAttributeImpl(AbstractManagedType<X> owner, FieldMetaData fmd) {
            super(owner, fmd);
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.SET;
        }
    }

    public static class ListAttributeImpl<X, E>
    extends PluralAttributeImpl<X, List<E>, E>
    implements ListAttribute<X, E> {
        public ListAttributeImpl(AbstractManagedType<X> owner, FieldMetaData fmd) {
            super(owner, fmd);
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.LIST;
        }
    }

    public static class CollectionAttributeImpl<X, E>
    extends PluralAttributeImpl<X, Collection<E>, E>
    implements CollectionAttribute<X, E> {
        public CollectionAttributeImpl(AbstractManagedType<X> owner, FieldMetaData fmd) {
            super(owner, fmd);
        }

        @Override
        public PluralAttribute.CollectionType getCollectionType() {
            return PluralAttribute.CollectionType.COLLECTION;
        }
    }

    public static abstract class PluralAttributeImpl<X, C, E>
    extends Member<X, C>
    implements PluralAttribute<X, C, E> {
        public PluralAttributeImpl(AbstractManagedType<X> owner, FieldMetaData fmd) {
            super(owner, fmd);
        }

        @Override
        public final Type<E> getElementType() {
            return this.owner.model.getType(this.getBindableJavaType());
        }

        @Override
        public final Bindable.BindableType getBindableType() {
            return Bindable.BindableType.PLURAL_ATTRIBUTE;
        }

        @Override
        public Class<E> getBindableJavaType() {
            return this.fmd.getElement().getDeclaredType();
        }

        @Override
        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            return Attribute.PersistentAttributeType.ONE_TO_MANY;
        }
    }

    public static final class SingularAttributeImpl<X, T>
    extends Member<X, T>
    implements SingularAttribute<X, T> {
        public SingularAttributeImpl(AbstractManagedType<X> owner, FieldMetaData fmd) {
            super(owner, fmd);
        }

        @Override
        public boolean isId() {
            return this.fmd.isPrimaryKey();
        }

        @Override
        public boolean isVersion() {
            return this.fmd.isVersion();
        }

        @Override
        public boolean isOptional() {
            return this.fmd.getNullValue() != 2;
        }

        @Override
        public Bindable.BindableType getBindableType() {
            return this.fmd.isDeclaredTypePC() ? Bindable.BindableType.ENTITY_TYPE : Bindable.BindableType.SINGULAR_ATTRIBUTE;
        }

        @Override
        public Class<T> getBindableJavaType() {
            return this.fmd.getElement().getDeclaredType();
        }

        @Override
        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            if (!this.fmd.isDeclaredTypePC()) {
                return super.getPersistentAttributeType();
            }
            if (this.fmd.getValue().isEmbedded() && this.fmd.getAssociationType() == 0) {
                return Attribute.PersistentAttributeType.EMBEDDED;
            }
            return this.fmd.getMappedByMetaData() == null || !this.fmd.getType().isAssignableFrom(Collection.class) ? Attribute.PersistentAttributeType.ONE_TO_ONE : Attribute.PersistentAttributeType.ONE_TO_MANY;
        }
    }

    public static abstract class Member<X, Y>
    implements Attribute<X, Y>,
    Comparable<Member<X, Y>> {
        public final AbstractManagedType<X> owner;
        public final FieldMetaData fmd;

        protected Member(AbstractManagedType<X> owner, FieldMetaData fmd) {
            this.owner = owner;
            this.fmd = fmd;
        }

        @Override
        public final ManagedType<X> getDeclaringType() {
            return this.owner.model.managedType(this.fmd.getDeclaringType());
        }

        @Override
        public final java.lang.reflect.Member getJavaMember() {
            return this.fmd.getBackingMember();
        }

        @Override
        public final Class<Y> getJavaType() {
            return this.fmd.getDeclaredType();
        }

        @Override
        public final String getName() {
            return this.fmd.getName();
        }

        public final Type<Y> getType() {
            return this.owner.model.getType(this.isCollection() ? this.fmd.getElement().getDeclaredType() : this.fmd.getDeclaredType());
        }

        @Override
        public final boolean isAssociation() {
            return this.fmd.isDeclaredTypePC();
        }

        @Override
        public final boolean isCollection() {
            int typeCode = this.fmd.getDeclaredTypeCode();
            return typeCode == 12 || typeCode == 13 || typeCode == 11;
        }

        @Override
        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            if (this.fmd.isEmbeddedPC()) {
                return Attribute.PersistentAttributeType.EMBEDDED;
            }
            if (this.fmd.isElementCollection()) {
                return Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
            }
            return Attribute.PersistentAttributeType.BASIC;
        }

        @Override
        public int compareTo(Member<X, Y> o) {
            return this.fmd.getName().compareTo(o.fmd.getName());
        }

        public String toString() {
            return this.fmd.getFullName(true);
        }
    }
}

