/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.Collection;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.SubqueryImpl;
import org.apache.openjpa.persistence.meta.Members;

class PathImpl<Z, X>
extends ExpressionImpl<X>
implements javax.persistence.criteria.Path<X> {
    protected final PathImpl<?, Z> _parent;
    protected final Members.Member<? super Z, ?> _member;
    private boolean isEmbedded = false;
    private PathImpl<?, ?> _correlatedPath;

    protected PathImpl(Class<X> cls) {
        super(cls);
        this._parent = null;
        this._member = null;
    }

    public PathImpl(PathImpl<?, Z> parent, Members.Member<? super Z, ?> member, Class<X> cls) {
        super(cls);
        this._parent = parent;
        if (this._parent.isEmbedded) {
            FieldMetaData fmd = this.getEmbeddedFieldMetaData(member.fmd);
            this._member = new Members.SingularAttributeImpl(member.owner, fmd);
        } else {
            this._member = member;
        }
        this.isEmbedded = this._member.fmd.isElementCollection() ? this._member.fmd.getElement().isEmbedded() : this._member.fmd.isEmbedded();
    }

    public Bindable<X> getModel() {
        if (!(this._member instanceof Bindable)) {
            throw new IllegalArgumentException(this + " represents a basic path and not a bindable");
        }
        return (Bindable)this._member;
    }

    public final javax.persistence.criteria.Path<Z> getParentPath() {
        return this._parent;
    }

    public PathImpl<?, ?> getInnermostParentPath() {
        return this._parent == null ? this : this._parent.getInnermostParentPath();
    }

    protected FieldMetaData getEmbeddedFieldMetaData(FieldMetaData fmd) {
        ClassMetaData embeddedMeta;
        Members.Member<? super Z, ? super Z> member = this.getInnermostMember(this._parent, this._member);
        ClassMetaData classMetaData = embeddedMeta = member.fmd.isElementCollection() ? member.fmd.getElement().getEmbeddedMetaData() : member.fmd.getEmbeddedMetaData();
        if (embeddedMeta != null) {
            return embeddedMeta.getField(fmd.getName());
        }
        return fmd;
    }

    protected Members.Member<?, ?> getInnermostMember(PathImpl<?, ?> parent, Members.Member<?, ?> member) {
        return member != null ? member : this.getInnermostMember(parent._parent, parent._member);
    }

    public void setCorrelatedPath(PathImpl<?, ?> correlatedPath) {
        this._correlatedPath = correlatedPath;
    }

    public PathImpl<?, ?> getCorrelatedPath() {
        return this._correlatedPath;
    }

    public boolean isCorrelated() {
        return this._correlatedPath != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        if (q.isRegistered(this)) {
            return q.getRegisteredValue(this);
        }
        Path path = null;
        SubqueryImpl<?> subquery = q.getDelegator();
        boolean allowNull = this._parent == null ? false : this._parent instanceof Join && ((Join)this._parent).getJoinType() != JoinType.INNER;
        PathImpl<?, ?> corrJoin = this.getCorrelatedJoin(this);
        PathImpl<?, ?> corrRoot = this.getCorrelatedRoot(subquery);
        if (this._parent != null && q.isRegistered(this._parent)) {
            path = factory.newPath(q.getRegisteredVariable(this._parent));
            path.setSchemaAlias(q.getAlias(this._parent));
            path.get(this._member.fmd, allowNull);
        } else if (this._parent != null && this._parent._correlatedPath != null && q.isRegistered(this._parent._correlatedPath)) {
            path = factory.newPath(q.getRegisteredVariable(this._parent._correlatedPath));
            path.setSchemaAlias(q.getAlias(this._parent._correlatedPath));
            path.get(this._member.fmd, allowNull);
        } else if (corrJoin != null || corrRoot != null) {
            Subquery subQ = subquery.getSubQ();
            path = factory.newPath(subQ);
            path.setMetaData(subQ.getMetaData());
            path.setSchemaAlias(q.getAlias(this._parent));
            this.traversePath(this._parent, path, this._member.fmd);
        } else if (this._parent != null) {
            Value val = this._parent.toValue(factory, q);
            if (!(val instanceof Path)) {
                val.setAlias(q.getAlias(this));
                return val;
            }
            path = (Path)val;
            path.get(this._member.fmd, allowNull);
        } else if (this._parent == null) {
            path = factory.newPath();
            path.setMetaData(q.getMetamodel().getRepository().getCachedMetaData(this.getJavaType()));
        }
        if (this._member != null && !this._member.isCollection()) {
            path.setImplicitType(this.getJavaType());
        }
        path.setAlias(q.getAlias(this));
        return path;
    }

    public PathImpl<?, ?> getCorrelatedRoot(SubqueryImpl<?> subquery) {
        if (subquery == null) {
            return null;
        }
        PathImpl<?, ?> root = this.getInnermostParentPath();
        if (subquery.getRoots() != null && subquery.getRoots().contains(this)) {
            return root;
        }
        return null;
    }

    public PathImpl<?, ?> getCorrelatedJoin(PathImpl<?, ?> path) {
        if (path._correlatedPath != null) {
            return path._correlatedPath;
        }
        if (path._parent == null) {
            return null;
        }
        return this.getCorrelatedJoin(path._parent);
    }

    public boolean inSubquery(SubqueryImpl<?> subquery) {
        return subquery != null && subquery.getRoots() != null && subquery.getRoots().contains(this);
    }

    protected void traversePath(PathImpl<?, ?> parent, Path path, FieldMetaData fmd) {
        boolean allowNull = parent == null ? false : parent instanceof Join && ((Join)parent).getJoinType() != JoinType.INNER;
        FieldMetaData fmd1 = parent._member == null ? null : parent._member.fmd;
        PathImpl<?, Z> parent1 = parent._parent;
        if (parent1 == null || parent1.getCorrelatedPath() != null) {
            if (fmd != null) {
                path.get(fmd, allowNull);
            }
            return;
        }
        this.traversePath(parent1, path, fmd1);
        if (fmd != null) {
            path.get(fmd, allowNull);
        }
    }

    public <Y> javax.persistence.criteria.Path<Y> get(SingularAttribute<? super X, Y> attr) {
        return new PathImpl<Z, X>(this, (Members.SingularAttributeImpl)attr, attr.getJavaType());
    }

    public <E, C extends Collection<E>> Expression<C> get(PluralAttribute<X, C, E> coll) {
        return new PathImpl<Z, X>(this, (Members.PluralAttributeImpl)coll, coll.getJavaType());
    }

    public <K, V, M extends Map<K, V>> Expression<M> get(MapAttribute<X, K, V> map) {
        return new PathImpl<Z, X>(this, (Members.MapAttributeImpl)map, map.getJavaType());
    }

    public <Y> javax.persistence.criteria.Path<Y> get(String attName) {
        Type<?> type = this.getType();
        if (type.getPersistenceType() == Type.PersistenceType.BASIC) {
            throw new IllegalArgumentException(this + " is a basic path and can not be navigated to " + attName);
        }
        Members.Member next = (Members.Member)((ManagedType)type).getAttribute(attName);
        return new PathImpl(this, next, next.getJavaType());
    }

    public Type<?> getType() {
        return this._member.getType();
    }

    public Members.Member<? extends Z, X> getMember() {
        return this._member;
    }

    public Expression<Class<? extends X>> type() {
        return new Expressions.Type<Class<? extends X>>(this);
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        StringBuilder buffer = new StringBuilder();
        if (this._parent != null) {
            Value var = q.getRegisteredVariable(this._parent);
            buffer.append(var != null ? var.getName() : this._parent.asValue(q)).append(".");
        }
        if (this._member != null) {
            buffer.append(this._member.fmd.getName());
        }
        return buffer;
    }

    @Override
    public StringBuilder asVariable(AliasContext q) {
        Value var = q.getRegisteredVariable(this);
        return this.asValue(q).append(" ").append(var == null ? "?" : var.getName());
    }
}

