/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.usermanager.impl.TransferRateRequest;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SITE_DESCUSER
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(SITE_DESCUSER.class);

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        UserManager userManager = context.getUserManager();
        boolean isAdmin = userManager.isAdmin(session.getUser().getName());
        if (!isAdmin) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 530, "SITE", null));
            return;
        }
        String argument = request.getArgument();
        int spIndex = argument.indexOf(32);
        if (spIndex == -1) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 503, "SITE.DESCUSER", null));
            return;
        }
        String userName = argument.substring(spIndex + 1);
        UserManager usrManager = context.getUserManager();
        User user = null;
        try {
            if (usrManager.doesExist(userName)) {
                user = usrManager.getUserByName(userName);
            }
        }
        catch (FtpException ex) {
            this.LOG.debug("Exception trying to get user from user manager", (Throwable)ex);
        }
        if (user == null) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "SITE.DESCUSER", userName));
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("\n");
        sb.append("userid          : ").append(user.getName()).append("\n");
        sb.append("userpassword    : ********\n");
        sb.append("homedirectory   : ").append(user.getHomeDirectory()).append("\n");
        sb.append("writepermission : ").append(user.authorize((AuthorizationRequest)new WriteRequest()) != null).append("\n");
        sb.append("enableflag      : ").append(user.getEnabled()).append("\n");
        sb.append("idletime        : ").append(user.getMaxIdleTime()).append("\n");
        TransferRateRequest transferRateRequest = new TransferRateRequest();
        transferRateRequest = (TransferRateRequest)session.getUser().authorize((AuthorizationRequest)transferRateRequest);
        if (transferRateRequest != null) {
            sb.append("uploadrate      : ").append(transferRateRequest.getMaxUploadRate()).append("\n");
            sb.append("downloadrate    : ").append(transferRateRequest.getMaxDownloadRate()).append("\n");
        } else {
            sb.append("uploadrate      : 0\n");
            sb.append("downloadrate    : 0\n");
        }
        sb.append('\n');
        session.write(new DefaultFtpReply(200, sb.toString()));
    }
}

