/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.time;

import org.joda.time.DateTimeField;
import org.joda.time.DurationField;
import uk.ac.rdg.resc.edal.time.DayOfMonthOfFixedYearDateTimeField;
import uk.ac.rdg.resc.edal.time.FixedYearLengthChronology;
import uk.ac.rdg.resc.edal.time.MonthOfFixedYearDateTimeField;

public class FixedYearVariableMonthChronology
extends FixedYearLengthChronology {
    private final int[] monthLengths;
    private final DateTimeField dayOfMonth;
    private final DateTimeField monthOfYear;
    private final DurationField monthDuration;

    public FixedYearVariableMonthChronology(int[] monthLengths) {
        super(FixedYearVariableMonthChronology.sumArray(monthLengths));
        this.monthLengths = (int[])monthLengths.clone();
        this.dayOfMonth = new DayOfMonthOfFixedYearDateTimeField(this);
        this.monthOfYear = new MonthOfFixedYearDateTimeField(this);
        this.monthDuration = this.monthOfYear.getDurationField();
    }

    private static int sumArray(int[] arr) {
        if (arr == null) {
            throw new NullPointerException("null array");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("Zero-length array");
        }
        int sum = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] <= 0) {
                throw new IllegalArgumentException("All array values must be > 0");
            }
            sum += arr[i];
        }
        return sum;
    }

    @Override
    public final DateTimeField dayOfMonth() {
        return this.dayOfMonth;
    }

    @Override
    public final DateTimeField monthOfYear() {
        return this.monthOfYear;
    }

    @Override
    public final DurationField months() {
        return this.monthDuration;
    }

    public int[] getMonthLengths() {
        return (int[])this.monthLengths.clone();
    }

    public long getAverageMillisInMonth() {
        return this.years().getUnitMillis() / (long)this.monthLengths.length;
    }

    public String toString() {
        return "Custom calendar: fixed year length, variable month length";
    }
}

