/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.keygen;

import java.net.InetAddress;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.castor.util.Messages;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class UUIDKeyGenerator
implements KeyGenerator {
    private DecimalFormat _df = new DecimalFormat();
    private String _sHost = null;
    private static long _staticCounter = 0L;

    public UUIDKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        this.supportsSqlType(sqlType);
    }

    public void supportsSqlType(int sqlType) throws MappingException {
        if (sqlType != 1 && sqlType != 12 && sqlType != -1) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        String sUUID = null;
        try {
            if (this._sHost == null) {
                this._sHost = InetAddress.getLocalHost().getHostAddress();
            }
            StringTokenizer st = new StringTokenizer(this._sHost, ".");
            this._df.applyPattern("000");
            while (st.hasMoreTokens()) {
                if (sUUID == null) {
                    sUUID = this._df.format(new Integer(st.nextToken()));
                    continue;
                }
                sUUID = sUUID + this._df.format(new Integer(st.nextToken()));
            }
            this._df.applyPattern("0000000000000");
            sUUID = sUUID + this._df.format(System.currentTimeMillis());
            if (_staticCounter >= 99999L) {
                _staticCounter = 0L;
            }
            this._df.applyPattern("00000");
            sUUID = sUUID + this._df.format(++_staticCounter);
        }
        catch (Exception ex) {
            throw new PersistenceException(Messages.format("persist.keyGenSQL", this.getClass().getName(), ex.toString()), ex);
        }
        if (sUUID == null) {
            throw new PersistenceException(Messages.format("persist.keyGenOverflow", this.getClass().getName()));
        }
        return sUUID;
    }

    public final byte getStyle() {
        return -1;
    }

    public final String patchSQL(String insert, String primKeyName) {
        return insert;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

