/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class PutCacheEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public PutCacheEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (3 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 3 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length == 3) {
            String space = (String)values[0];
            String key = (String)values[1];
            space = space.replace("\"", "");
            key = key.replace("\"", "");
            Object value = values[2];
            ConcurrentMap<String, ConcurrentMap<String, Object>> objectCache = this.streamContext.getObjectCache();
            ConcurrentMap spaceCache = objectCache.computeIfAbsent(space, k -> new ConcurrentHashMap());
            spaceCache.put(key, value);
            return value;
        }
        throw new IOException("The putCache function requires three parameters: workspace, key and value");
    }
}

