/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Timestamp {
    protected Element element = null;
    protected Vector customElements = null;
    protected Calendar created;
    protected Calendar expires;

    public Timestamp(Element element) throws WSSecurityException {
        this.element = element;
        this.customElements = new Vector();
        String strCreated = null;
        String strExpires = null;
        for (Node currentChild = element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            if ("Created".equals(currentChild.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(currentChild.getNamespaceURI())) {
                if (strCreated == null) {
                    strCreated = ((Text)((Element)currentChild).getFirstChild()).getData();
                    continue;
                }
                throw new WSSecurityException(3, "invalidTimestamp");
            }
            if ("Expires".equals(currentChild.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(currentChild.getNamespaceURI())) {
                if (strExpires == null) {
                    strExpires = ((Text)((Element)currentChild).getFirstChild()).getData();
                    continue;
                }
                throw new WSSecurityException(3, "invalidTimestamp");
            }
            this.customElements.add((Element)currentChild);
        }
        XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
        try {
            if (strCreated != null) {
                this.created = Calendar.getInstance();
                this.created.setTime(zulu.parse(strCreated));
            }
            if (strExpires != null) {
                this.expires = Calendar.getInstance();
                this.expires.setTime(zulu.parse(strExpires));
            }
        }
        catch (ParseException e) {
            throw new WSSecurityException(3, "invalidTimestamp", null, e);
        }
    }

    public Timestamp(boolean milliseconds, Document doc, int ttl) {
        this.customElements = new Vector();
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        DateFormat zulu = null;
        if (milliseconds) {
            zulu = new XmlSchemaDateFormat();
        } else {
            zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        this.created = this.getCurrentTime();
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        elementCreated.appendChild(doc.createTextNode(zulu.format(this.created.getTime())));
        this.element.appendChild(elementCreated);
        if (ttl != 0) {
            long currentTime = this.created.getTimeInMillis();
            this.expires = this.getCurrentTime();
            this.expires.setTimeInMillis(currentTime += (long)(ttl * 1000));
            Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
            elementExpires.appendChild(doc.createTextNode(zulu.format(this.expires.getTime())));
            this.element.appendChild(elementExpires);
        }
    }

    protected Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public void addCustomElement(Document doc, Element customElement) {
        this.customElements.add(customElement);
        this.element.appendChild(customElement);
    }

    public Vector getCustomElements() {
        return this.customElements;
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }
}

