/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.color.ColorSpace;
import org.apache.sis.internal.util.Numerics;

final class ScaledColorSpace
extends ColorSpace {
    private static final long serialVersionUID = -5146474397268513490L;
    final double scale;
    final double offset;
    final double maximum;
    final int visibleBand;

    ScaledColorSpace(int n, int n2, double d, double d2) {
        super(6, n);
        this.visibleBand = n2;
        this.maximum = d2;
        this.scale = 256.0 / (d2 - d);
        this.offset = d;
    }

    ScaledColorSpace(ScaledColorSpace scaledColorSpace, int[] nArray) {
        super(6, nArray.length);
        this.scale = scaledColorSpace.scale;
        this.offset = scaledColorSpace.offset;
        this.maximum = scaledColorSpace.maximum;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != scaledColorSpace.visibleBand) continue;
            this.visibleBand = i;
            return;
        }
        this.visibleBand = 0;
    }

    @Override
    public float[] toRGB(float[] fArray) {
        float f = Math.min(1.0f, (float)(((double)fArray[this.visibleBand] - this.offset) * (0.00390625 * this.scale)));
        if (!(f >= 0.0f)) {
            f = 0.0f;
        }
        return new float[]{f, f, f};
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        float[] fArray2 = new float[this.getNumComponents()];
        fArray2[this.visibleBand] = (float)((double)(fArray[0] + fArray[1] + fArray[2]) / (0.01171875 * this.scale) + this.offset);
        return fArray2;
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        float[] fArray2 = this.toRGB(fArray);
        fArray2[0] = fArray2[0] * 0.9642f;
        fArray2[2] = fArray2[2] * 0.8249f;
        return fArray2;
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        float[] fArray2 = new float[this.getNumComponents()];
        fArray2[this.visibleBand] = (float)((double)(fArray[0] / 0.9642f + fArray[1] + fArray[2] / 0.8249f) / (0.01171875 * this.scale) + this.offset);
        return fArray2;
    }

    @Override
    public float getMinValue(int n) {
        return (float)this.offset;
    }

    @Override
    public float getMaxValue(int n) {
        return (float)this.maximum;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20).append(this.getClass().getSimpleName());
        this.formatRange(stringBuilder);
        return stringBuilder.toString();
    }

    final void formatRange(StringBuilder stringBuilder) {
        stringBuilder.append('[').append(this.offset).append(" \u2026 ").append(this.maximum).append(" in band ").append(this.visibleBand).append(']');
    }

    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.scale) + 31L * Double.doubleToLongBits(this.offset)) + 7 * this.getNumComponents() + this.visibleBand;
    }

    public boolean equals(Object object) {
        if (object instanceof ScaledColorSpace) {
            ScaledColorSpace scaledColorSpace = (ScaledColorSpace)object;
            return Numerics.equals(this.scale, scaledColorSpace.scale) && Numerics.equals(this.offset, scaledColorSpace.offset) && Numerics.equals(this.maximum, scaledColorSpace.maximum) && this.visibleBand == scaledColorSpace.visibleBand && this.getNumComponents() == scaledColorSpace.getNumComponents() && this.getType() == scaledColorSpace.getType();
        }
        return false;
    }
}

