/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.RuleSet;
import java.util.ArrayList;
import java.util.List;

public abstract class TreeDeclarationsVisitor {
    public void apply(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                RuleSet ruleset = (RuleSet)node;
                this.rulesetsBodyPropertiesMerger(ruleset.getBody());
                break;
            }
            case CHARSET_DECLARATION: 
            case IMPORT: {
                break;
            }
            default: {
                this.applyToKidsProperties(node);
            }
        }
    }

    private void applyToKidsProperties(ASTCssNode node) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            this.apply(aSTCssNode);
        }
    }

    private void rulesetsBodyPropertiesMerger(Body node) {
        this.enteringBody(node);
        List<ASTCssNode> childs = node.getChilds();
        block3: for (ASTCssNode kid : childs) {
            switch (kid.getType()) {
                case DECLARATION: {
                    this.applyToDeclaration((Declaration)kid);
                    continue block3;
                }
            }
            this.applyToKidsProperties(kid);
        }
        this.leavingBody(node);
    }

    protected abstract void applyToDeclaration(Declaration var1);

    protected abstract void enteringBody(Body var1);

    protected abstract void leavingBody(Body var1);
}

