/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.common.util.concurrent.BaseFuture;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public class PlainTransportFuture<V extends TransportResponse>
extends BaseFuture<V>
implements TransportFuture<V>,
TransportResponseHandler<V> {
    private final TransportResponseHandler<V> handler;

    public PlainTransportFuture(TransportResponseHandler<V> handler) {
        this.handler = handler;
    }

    @Override
    public V txGet() throws ElasticsearchException {
        try {
            return (V)((TransportResponse)this.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElasticsearchIllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ElasticsearchException) {
                throw (ElasticsearchException)e.getCause();
            }
            throw new TransportException("Failed execution", e);
        }
    }

    @Override
    public V txGet(long timeout, TimeUnit unit) throws ElasticsearchException {
        try {
            return (V)((TransportResponse)this.get(timeout, unit));
        }
        catch (TimeoutException e) {
            throw new ElasticsearchTimeoutException(e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElasticsearchIllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ElasticsearchException) {
                throw (ElasticsearchException)e.getCause();
            }
            throw new TransportException("Failed execution", e);
        }
    }

    @Override
    public V newInstance() {
        return this.handler.newInstance();
    }

    @Override
    public String executor() {
        return this.handler.executor();
    }

    @Override
    public void handleResponse(V response) {
        try {
            this.handler.handleResponse(response);
            this.set(response);
        }
        catch (Throwable t) {
            this.handleException(new ResponseHandlerFailureTransportException(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(TransportException exp) {
        try {
            this.handler.handleException(exp);
        }
        finally {
            this.setException(exp);
        }
    }

    public String toString() {
        return "future(" + this.handler.toString() + ")";
    }
}

