/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.facet.FacetParser;

public class FacetParsers {
    private final ImmutableMap<String, FacetParser> parsers;

    @Inject
    public FacetParsers(Set<FacetParser> parsers) {
        MapBuilder<String, FacetParser> builder = MapBuilder.newMapBuilder();
        for (FacetParser parser : parsers) {
            for (String type : parser.types()) {
                builder.put(type, parser);
            }
        }
        this.parsers = builder.immutableMap();
    }

    public FacetParser parser(String type) {
        return this.parsers.get(type);
    }
}

