/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.rest.AbstractRestResponseActionListener;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestTable;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class RestThreadPoolAction
extends AbstractCatAction {
    private static final String[] SUPPORTED_NAMES = new String[]{"bulk", "flush", "generic", "get", "index", "management", "merge", "optimize", "percolate", "refresh", "search", "snapshot", "suggest", "warmer"};
    private static final String[] SUPPORTED_ALIASES = new String[]{"b", "f", "ge", "g", "i", "ma", "m", "o", "p", "r", "s", "sn", "su", "w"};
    private static final String[] DEFAULT_THREAD_POOLS = new String[]{"bulk", "index", "search"};
    private static final Map<String, String> ALIAS_TO_THREAD_POOL = Maps.newHashMapWithExpectedSize(SUPPORTED_NAMES.length);
    private static final Map<String, String> THREAD_POOL_TO_ALIAS;

    @Inject
    public RestThreadPoolAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/thread_pool", this);
    }

    @Override
    void documentation(StringBuilder sb) {
        sb.append("/_cat/thread_pool\n");
    }

    @Override
    public void doRequest(RestRequest request, RestChannel channel) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        final String[] pools = this.fetchSortedPools(request, DEFAULT_THREAD_POOLS);
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new AbstractRestResponseActionListener<ClusterStateResponse>(request, channel, this.logger){

            @Override
            public void onResponse(final ClusterStateResponse clusterStateResponse) {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest();
                nodesInfoRequest.clear().process(true);
                RestThreadPoolAction.this.client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener<NodesInfoResponse>)new AbstractRestResponseActionListener<NodesInfoResponse>(this.request, this.channel, this.logger){

                    @Override
                    public void onResponse(final NodesInfoResponse nodesInfoResponse) {
                        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(new String[0]);
                        nodesStatsRequest.clear().threadPool(true);
                        RestThreadPoolAction.this.client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener<NodesStatsResponse>)new AbstractRestResponseActionListener<NodesStatsResponse>(this.request, this.channel, this.logger){

                            @Override
                            public void onResponse(NodesStatsResponse nodesStatsResponse) {
                                try {
                                    this.channel.sendResponse(RestTable.buildResponse(RestThreadPoolAction.this.buildTable(this.request, clusterStateResponse, nodesInfoResponse, nodesStatsResponse, pools), this.request, this.channel));
                                }
                                catch (Throwable e) {
                                    this.onFailure(e);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("id", "default:false;alias:id,nodeId;desc:unique node id");
        table.addCell("pid", "default:false;alias:p;desc:process id");
        table.addCell("host", "alias:h;desc:host name");
        table.addCell("ip", "alias:i;desc:ip address");
        table.addCell("port", "default:false;alias:po;desc:bound transport port");
        String[] requestedPools = this.fetchSortedPools(request, DEFAULT_THREAD_POOLS);
        for (String pool : SUPPORTED_NAMES) {
            String poolAlias = THREAD_POOL_TO_ALIAS.get(pool);
            boolean display = false;
            for (String requestedPool : requestedPools) {
                if (!pool.equals(requestedPool)) continue;
                display = true;
                break;
            }
            String defaultDisplayVal = Boolean.toString(display);
            table.addCell(pool + ".active", "alias:" + poolAlias + "a;default:" + defaultDisplayVal + ";text-align:right;desc:number of active " + pool + " threads");
            table.addCell(pool + ".size", "alias:" + poolAlias + "s;default:false;text-align:right;desc:number of active " + pool + " threads");
            table.addCell(pool + ".queue", "alias:" + poolAlias + "q;default:" + defaultDisplayVal + ";text-align:right;desc:number of " + pool + " threads in queue");
            table.addCell(pool + ".rejected", "alias:" + poolAlias + "r;default:" + defaultDisplayVal + ";text-align:right;desc:number of rejected " + pool + " threads");
            table.addCell(pool + ".largest", "alias:" + poolAlias + "l;default:false;text-align:right;desc:highest number of seen active " + pool + " threads");
            table.addCell(pool + ".completed", "alias:" + poolAlias + "c;default:false;text-align:right;desc:number of completed " + pool + " threads");
        }
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo, NodesStatsResponse nodesStats, String[] pools) {
        boolean fullId = req.paramAsBoolean("full_id", false);
        DiscoveryNodes nodes = state.getState().nodes();
        Table table = this.getTableWithHeader(req);
        for (DiscoveryNode node : nodes) {
            Map<String, ThreadPoolStats.Stats> poolThreadStats;
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.id());
            NodeStats stats = (NodeStats)nodesStats.getNodesMap().get(node.id());
            table.startRow();
            table.addCell(fullId ? node.id() : Strings.substring(node.getId(), 0, 4));
            table.addCell(info == null ? null : Long.valueOf(info.getProcess().id()));
            table.addCell(node.getHostName());
            table.addCell(node.getHostAddress());
            if (node.address() instanceof InetSocketTransportAddress) {
                table.addCell(((InetSocketTransportAddress)node.address()).address().getPort());
            } else {
                table.addCell("-");
            }
            if (stats == null) {
                poolThreadStats = Collections.emptyMap();
            } else {
                poolThreadStats = new HashMap(14);
                ThreadPoolStats threadPoolStats = stats.getThreadPool();
                for (ThreadPoolStats.Stats threadPoolStat : threadPoolStats) {
                    poolThreadStats.put(threadPoolStat.getName(), threadPoolStat);
                }
            }
            for (String pool : SUPPORTED_NAMES) {
                ThreadPoolStats.Stats poolStats = (ThreadPoolStats.Stats)poolThreadStats.get(pool);
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getActive()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getThreads()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getQueue()));
                table.addCell(poolStats == null ? null : Long.valueOf(poolStats.getRejected()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getLargest()));
                table.addCell(poolStats == null ? null : Long.valueOf(poolStats.getCompleted()));
            }
            table.endRow();
        }
        return table;
    }

    private String[] fetchSortedPools(RestRequest request, String[] defaults) {
        String[] headers = request.paramAsStringArray("h", null);
        if (headers == null) {
            return defaults;
        }
        LinkedHashSet<String> requestedPools = new LinkedHashSet<String>(headers.length);
        for (String header : headers) {
            int dotIndex = header.indexOf(46);
            if (dotIndex != -1) {
                String headerPrefix = header.substring(0, dotIndex);
                if (!THREAD_POOL_TO_ALIAS.containsKey(headerPrefix)) continue;
                requestedPools.add(headerPrefix);
                continue;
            }
            if (!ALIAS_TO_THREAD_POOL.containsKey(header)) continue;
            requestedPools.add(ALIAS_TO_THREAD_POOL.get(header));
        }
        return requestedPools.toArray(new String[requestedPools.size()]);
    }

    static {
        for (String supportedThreadPool : SUPPORTED_NAMES) {
            ALIAS_TO_THREAD_POOL.put(supportedThreadPool.substring(0, 3), supportedThreadPool);
        }
        THREAD_POOL_TO_ALIAS = Maps.newHashMapWithExpectedSize(SUPPORTED_NAMES.length);
        for (int i = 0; i < SUPPORTED_NAMES.length; ++i) {
            THREAD_POOL_TO_ALIAS.put(SUPPORTED_NAMES[i], SUPPORTED_ALIASES[i]);
        }
    }
}

