/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeReadOperationAction<Request extends MasterNodeReadOperationRequest, Response extends ActionResponse>
extends TransportMasterNodeOperationAction<Request, Response> {
    public static final String FORCE_LOCAL_SETTING = "action.master.force_local";
    private Boolean forceLocal;

    protected TransportMasterNodeReadOperationAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
        this.forceLocal = settings.getAsBoolean(FORCE_LOCAL_SETTING, null);
    }

    @Override
    protected final boolean localExecute(Request request) {
        if (this.forceLocal != null) {
            return this.forceLocal;
        }
        return ((MasterNodeReadOperationRequest)request).local();
    }
}

