/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import com.google.common.collect.Maps;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.parser.AbstractDataParser;

public class CsvDataParser2
extends AbstractDataParser<ByteBuffer>
implements Serializable {
    private static final CSVParser csvParser = new CSVParserBuilder().withSeparator('|').build();
    private static final String[] header = new String[]{"id", "name", "job", "sports", "ts"};

    protected Map<String, Object> parse(ByteBuffer input) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CSVReader csvReader = new CSVReaderBuilder(new StringReader(StandardCharsets.UTF_8.decode(input).toString())).withCSVParser(csvParser).build();
        HashMap outputMap = Maps.newHashMap();
        String[] strings = csvReader.readAll().get(0);
        if (strings.length + 1 != header.length) {
            throw new RuntimeException(String.format(Locale.ROOT, "header length is [%s], data column length is [%s]", header.length, strings.length));
        }
        for (int i = 0; i < header.length - 1; ++i) {
            outputMap.put(header[i], strings[i]);
        }
        outputMap.put(header[header.length - 1], format.format(new Date()));
        csvReader.close();
        return outputMap;
    }
}

