/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.regex;

import java.util.function.Predicate;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavascriptRegex
implements Predicate<CharSequence> {
    private static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("javascript");
    private final String regex;
    private final String indicators;

    public JavascriptRegex(String regex) {
        if (regex.startsWith("/") && regex.length() > 1) {
            int end = regex.lastIndexOf(47);
            if (end < 0) {
                this.regex = regex;
                this.indicators = "";
            } else {
                this.regex = regex.substring(1, end);
                this.indicators = regex.substring(end + 1);
            }
        } else {
            this.regex = regex;
            this.indicators = "";
        }
    }

    @Override
    public boolean test(CharSequence string) {
        Bindings bindings = ENGINE.createBindings();
        bindings.put("text", (Object)string);
        bindings.put("regex", (Object)this.regex);
        bindings.put("indicators", (Object)this.indicators);
        try {
            return (Boolean)Boolean.class.cast(ENGINE.eval("new RegExp(regex, indicators).test(text)", bindings));
        }
        catch (ScriptException e) {
            return false;
        }
    }

    public String toString() {
        return "JavascriptRegex{/" + this.regex + "/" + this.indicators + '}';
    }
}

