/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.vault.metadata;

import java.util.Objects;

import org.apache.james.vault.DeletedMessage;

import com.google.common.base.Preconditions;

public class DeletedMessageWithStorageInformation {
    private final DeletedMessage deletedMessage;
    private final StorageInformation storageInformation;

    public DeletedMessageWithStorageInformation(DeletedMessage deletedMessage, StorageInformation storageInformation) {
        Preconditions.checkNotNull(deletedMessage);
        Preconditions.checkNotNull(storageInformation);

        this.deletedMessage = deletedMessage;
        this.storageInformation = storageInformation;
    }

    public DeletedMessage getDeletedMessage() {
        return deletedMessage;
    }

    public StorageInformation getStorageInformation() {
        return storageInformation;
    }

    @Override
    public final boolean equals(Object o) {
        if (o instanceof DeletedMessageWithStorageInformation) {
            DeletedMessageWithStorageInformation that = (DeletedMessageWithStorageInformation) o;

            return Objects.equals(this.deletedMessage, that.deletedMessage)
                && Objects.equals(this.storageInformation, that.storageInformation);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return Objects.hash(deletedMessage, storageInformation);
    }
}
